/* This is an autogenerated file */
/* Tag: noCheckHeader */

/*    CONFIDENTIAL */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2008. All rights reserved. */

#include "sme_top_level_fsm/sme.h"
#include "smeio/smeio_fsm_events.h"
#include "event_pack_unpack/event_pack_unpack.h"

CsrUint16 serialise_unifi_sys_capabilities_cfm(CsrUint8** resultBuffer, void* appHandle, CsrUint16 commandQueueSize, CsrUint16 trafficQueueSize)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 2;
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_CAPABILITIES_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint16(&buffer, commandQueueSize);
    packedLength += event_pack_CsrUint16(&buffer, trafficQueueSize);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_eapol_cfm(CsrUint8** resultBuffer, void* appHandle, unifi_EapolRc result)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_EAPOL_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)result);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_hip_ind(CsrUint8** resultBuffer, CsrUint16 mlmeCommandLength, const CsrUint8 *mlmeCommand, CsrUint16 dataRef1Length, const CsrUint8 *dataRef1, CsrUint16 dataRef2Length, const CsrUint8 *dataRef2)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 2;
    if (mlmeCommandLength)
    {
        packedSize += mlmeCommandLength;
    }
    packedSize += 2;
    if (dataRef1Length)
    {
        packedSize += dataRef1Length;
    }
    packedSize += 2;
    if (dataRef2Length)
    {
        packedSize += dataRef2Length;
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_HIP_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, mlmeCommandLength);
    if (mlmeCommandLength)
    {
        packedLength += event_pack_buffer(&buffer, mlmeCommand, mlmeCommandLength);
    }
    packedLength += event_pack_CsrUint16(&buffer, dataRef1Length);
    if (dataRef1Length)
    {
        packedLength += event_pack_buffer(&buffer, dataRef1, dataRef1Length);
    }
    packedLength += event_pack_CsrUint16(&buffer, dataRef2Length);
    if (dataRef2Length)
    {
        packedLength += event_pack_buffer(&buffer, dataRef2, dataRef2Length);
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_ip_configured_ind(CsrUint8** resultBuffer, CsrBool ipConfigured)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_IP_CONFIGURED_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)ipConfigured);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_m4_transmitted_ind(CsrUint8** resultBuffer)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_M4_TRANSMITTED_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_ma_unitdata_ind(CsrUint8** resultBuffer, void* appHandle, CsrUint8 subscriptionHandle, CsrUint16 frameLength, const CsrUint8 *frame, unifi_FrameFreeFunction freeFunction, unifi_ReceptionStatus receptionStatus, unifi_Priority priority, unifi_ServiceClass serviceClass)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 2;
    if (frameLength)
    {
        packedSize += frameLength;
    }
    packedSize += 4;
    packedSize += 2;
    packedSize += 2;
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_MA_UNITDATA_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, subscriptionHandle);
    packedLength += event_pack_CsrUint16(&buffer, frameLength);
    if (frameLength)
    {
        packedLength += event_pack_buffer(&buffer, frame, frameLength);
    }
    packedLength += event_pack_CsrUint32(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)receptionStatus);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)priority);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)serviceClass);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_ma_unitdata_cfm(CsrUint8** resultBuffer, void* appHandle, unifi_Status result, unifi_TransmissionStatus transmissionStatus, unifi_Priority providedPriority, unifi_ServiceClass providedServiceClass, CsrUint32 reqIdentifier)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 2;
    packedSize += 2;
    packedSize += 2;
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_MA_UNITDATA_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)result);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)transmissionStatus);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)providedPriority);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)providedServiceClass);
    packedLength += event_pack_CsrUint32(&buffer, reqIdentifier);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_ma_unitdata_subscribe_cfm(CsrUint8** resultBuffer, void* appHandle, CsrUint8 subscriptionHandle, unifi_SubscriptionResult status, CsrUint16 allocOffset)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 1;
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, subscriptionHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);
    packedLength += event_pack_CsrUint16(&buffer, allocOffset);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_ma_unitdata_unsubscribe_cfm(CsrUint8** resultBuffer, void* appHandle, unifi_SubscriptionResult status)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_multicast_address_ind(CsrUint8** resultBuffer, unifi_ListAction action, CsrUint8 setAddressesCount, const unifi_MACAddress *setAddresses)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;
    packedSize += 1;
    if (setAddressesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setAddressesCount; i1++)
        {
            packedSize += 6;
        }
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_MULTICAST_ADDRESS_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)action);
    packedLength += event_pack_CsrUint8(&buffer, setAddressesCount);
    if (setAddressesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setAddressesCount; i1++)
        {
            packedLength += event_pack_buffer(&buffer, setAddresses[i1].data, 6);
        }
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_port_configure_cfm(CsrUint8** resultBuffer, unifi_Status status, const unifi_MACAddress *macAddress)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;
    packedSize += 6;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_PORT_CONFIGURE_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);
    packedLength += event_pack_buffer(&buffer, macAddress->data, 6);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_qos_control_cfm(CsrUint8** resultBuffer, unifi_Status status)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_QOS_CONTROL_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_resume_ind(CsrUint8** resultBuffer, CsrBool powerMaintained)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_RESUME_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)powerMaintained);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_suspend_ind(CsrUint8** resultBuffer, CsrBool hardSuspend, CsrBool d3Suspend)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 2;
    packedSize += 2;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_SUSPEND_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)hardSuspend);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)d3Suspend);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_tclas_add_cfm(CsrUint8** resultBuffer, unifi_Status status)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_TCLAS_ADD_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_tclas_del_cfm(CsrUint8** resultBuffer, unifi_Status status)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_TCLAS_DEL_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_traffic_protocol_ind(CsrUint8** resultBuffer, unifi_TrafficPacketType packetType, unifi_ProtocolDirection direction, const unifi_MACAddress *srcAddress)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 2;
    packedSize += 2;
    packedSize += 6;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_TRAFFIC_PROTOCOL_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)packetType);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)direction);
    packedLength += event_pack_buffer(&buffer, srcAddress->data, 6);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_traffic_sample_ind(CsrUint8** resultBuffer, const unifi_TrafficStats *stats)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;
    packedSize += 11;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_TRAFFIC_SAMPLE_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, stats->rxMeanRate);
    packedLength += event_pack_CsrUint32(&buffer, stats->rxFramesNum);
    packedLength += event_pack_CsrUint32(&buffer, stats->txFramesNum);
    packedLength += event_pack_CsrUint32(&buffer, stats->rxBytesCount);
    packedLength += event_pack_CsrUint32(&buffer, stats->txBytesCount);
    packedLength += event_pack_buffer(&buffer, stats->intervals, 11);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_wifi_off_ind(CsrUint8** resultBuffer, unifi_ControlIndication controlIndication)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_WIFI_OFF_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)controlIndication);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_wifi_off_cfm(CsrUint8** resultBuffer)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_WIFI_OFF_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_wifi_on_ind(CsrUint8** resultBuffer, unifi_Status status, const unifi_DriverVersions *driverVersions)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_WIFI_ON_IND_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);
    packedLength += event_pack_CsrUint32(&buffer, driverVersions->chipId);
    packedLength += event_pack_CsrUint32(&buffer, driverVersions->chipVersion);
    packedLength += event_pack_CsrUint32(&buffer, driverVersions->firmwareBuild);
    packedLength += event_pack_CsrUint32(&buffer, driverVersions->firmwareHip);
    packedLength += event_pack_CsrUint32(&buffer, driverVersions->driverBuild);
    packedLength += event_pack_CsrUint32(&buffer, driverVersions->driverHip);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_sys_wifi_on_cfm(CsrUint8** resultBuffer, unifi_Status status)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_SYS_WIFI_ON_CFM_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)status);

    *resultBuffer = evt;
    return packedLength;
}


