/* Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __ADSP_AUDIO_CONFIG_IDS_H
#define __ADSP_AUDIO_CONFIG_IDS_H


/* Configurable Algorithm Aspect IDs */
#define ADSP_AUDIO_IID_ENABLE_FLAG			0x0108b6b9
#define ADSP_AUDIO_IID_ADRC_CONFIG_PARAM		0x0108b6ba
#define ADSP_AUDIO_IID_IIR_PREGAIN			0x0108b6bc
#define ADSP_AUDIO_IID_IIR_PARAM			0x0108b6be
#define ADSP_AUDIO_IID_AGC_PARAM			0x0108b6c0
#define ADSP_AUDIO_IID_AVC_TX_PARAM			0x0108b6c2
#define ADSP_AUDIO_IID_AVC_RX_PARAM			0x0108b6c3
#define ADSP_AUDIO_IID_EC_TX_PARAM			0x0108b6c1
#define ADSP_AUDIO_IID_EC_RX_PARAM			0x0108b6c4
#define ADSP_AUDIO_IID_VOICEFE_FILTERS_PARAM		0x0108b6c5
#define ADSP_AUDIO_IID_AUDIO_AGC_CONFIG_PARAMS		0x0108b6c6
#define ADSP_AUDIO_IID_VOLUME_CONTROL_PARAM		0x0108b6c7
#define ADSP_AUDIO_IID_AUDIO_MIXER_CONFIG_PARAMS	0x0108b6c8
#define ADSP_AUDIO_IID_AFE_DUALMIC_SIDETONE		0x010911e4
#define ADSP_AUDIO_IID_AFE_SINGLEMIC_SIDETONE		0x010911e5
#define ADSP_AUDIO_IID_AFEI2S_PARAM			0x0108bd61
#define ADSP_AUDIO_IID_AFEPCM_PARAM			0x0108bd62
#define ADSP_AUDIO_IID_AFE_MT_PARAM			0x0108d423
#define ADSP_AUDIO_IID_ADRCMB_CONFIG_PARAM		0x0108d8fd


/* Algorithm Block IDs */

/* TX filters */
#define ADSP_AUDIO_UID_TX_AFE_PCM_SOURCE		0x01073d67
#define ADSP_AUDIO_UID_TX_AFE_I2S_SOURCE		0x01073d68
#define ADSP_AUDIO_UID_TX_GLOBAL_IIR			0x01073d69
#define ADSP_AUDIO_UID_TX_AUDIO_AGC			0x01073d6a
#define ADSP_AUDIO_UID_TX_VFE				0x01073d6b
#define ADSP_AUDIO_UID_TX_EC				0x01073d6c
#define ADSP_AUDIO_UID_TX_EC_FLUENCE			0x0108f9c6
#define ADSP_AUDIO_UID_TX_AVC				0x01073d6d
#define ADSP_AUDIO_UID_TX_AGC				0x01073d6e
#define ADSP_AUDIO_UID_TX_VOICE_IIR			0x01073d6f
#define ADSP_AUDIO_UID_TX_VOLUME			0x01073d70

/* RX filters */
#define ADSP_AUDIO_UID_RX_AFE_PCM_SINK			0x01073d74
#define ADSP_AUDIO_UID_RX_AFE_I2S_SINK			0x01073d75
#define ADSP_AUDIO_UID_RX_COMMON_IIR			0x01073d76
#define ADSP_AUDIO_UID_RX_ADRC				0x01073d78
#define ADSP_AUDIO_UID_RX_GLOBAL_MIXER			0x01073d79
#define ADSP_AUDIO_UID_RX_VFE				0x01073d7a
#define ADSP_AUDIO_UID_RX_EC				0x01073d7b
#define ADSP_AUDIO_UID_RX_VOICE_IIR			0x01073d7c
#define ADSP_AUDIO_UID_RX_AVC				0x01073d7d
#define ADSP_AUDIO_UID_RX_AGC				0x01073d7e
#define ADSP_AUDIO_UID_RX_ADRCMB			0x0108d8ff



/* AVC/RVE Tx Parameters */
/* IIDs known to Configurator */
#define ADSP_AUDIO_UID_TX_AVC_RVE			0x0108f47f
#define ADSP_AUDIO_IID_RVE_PARAM			0x0108f3fc
#define ADSP_AUDIO_IID_TX_RVE_ENABLE			0x0108f3ee
#define ADSP_AUDIO_IID_RX_VOLUME			0x0108f3ea
#define ADSP_AUDIO_IID_COMP_FLINK_THRESHOLD		0x0108f3eb
#define ADSP_AUDIO_IID_RVE_TX_PARAM			0x0108f3ec
#define ADSP_AUDIO_IID_TX_RVE_IS			0x0108f3fa
#define ADSP_AUDIO_IID_TX_RVE_WNR			0x0108f3fd
#define ADSP_AUDIO_IID_RVE_TX_OP_MODE			0x0108f3ed

/* AVC/RVE Rx */
#define ADSP_AUDIO_IID_RX_RVE_ENABLE			0x0108f3ef
#define ADSP_AUDIO_IID_RVE_RX_PARAM			0x0108f3f0
#define ADSP_AUDIO_IID_RX_RVE_WNR			0x0108f3f1
#define ADSP_AUDIO_IID_RX_RVE_IS			0x0108f3f2
#define ADSP_AUDIO_IID_RX_RVE_NOISE			0x0108f3f3
#define ADSP_AUDIO_IID_RX_AVC_GAIN			0x0108f3f4

/* Voice FE filters */
/* MIC 1 */
#define ADSP_AUDIO_IID_MIC1_IIR_PREGAIN			0x0108f3f5
#define ADSP_AUDIO_IID_MIC1_IIR_PARAM			0x0108f3f6
#define ADSP_AUDIO_IID_MIC1_IIR_ENABLE_FLAG		0x0108f3f9


/* MIC 2 */
#define ADSP_AUDIO_IID_MIC2_IIR_PREGAIN			0x0108f3f7
#define ADSP_AUDIO_IID_MIC2_IIR_PARAM			0x0108f3f8
#define ADSP_AUDIO_IID_MIC2_IIR_ENABLE_FLAG		0x0108f3fb


#endif
