#!/bin/sh
#
# clean files for restore
#

exit_status=1

case "$1" in
    backup)
	cd /
	if [ -f /home/system/var/lib/pcmcia/scheme ]; then
	    cp -p /home/system/var/lib/pcmcia/scheme /home/pcmcia_scheme.backup
	fi
	tar cf $2 --exclude home/system/var --exclude home/etc/mtab --exclude hdd2/tmp --exclude hdd2/lost+found home hdd2
	exit_status=$?
	rm -f /home/pcmcia_scheme.backup
	;;

    restore)
	cd /
	tar xf $2
	exit_status=$?
	if [ -f /home/pcmcia_scheme.backup ]; then
	    mkdir -p /home/system/var/lib/pcmcia
	    mv /home/pcmcia_scheme.backup /home/system/var/lib/pcmcia/scheme
	fi
	;;

    restorepc)
    until [ -f /home/tmp/autoexec.sh ]; do
        sleep 1;
    done
    set_host
    /bin/bash
    export UNICODEMAP_JP=open-19970715-ms,cp932,nec-vdc,ibm-vdc,udc
    export LANG=ja
    chmod +x /home/tmp/autoexec.sh
    bash /home/tmp/autoexec.sh
#    sh /home/tmp/autoexec.sh
    rm /home/tmp/autoexec.sh
    ;;

    clean)
	cd /home
	for i in `ls -A`;
	do
	    if [ $i = "etc" ]; then
		echo -n
	    elif [ $i = "tmp" ]; then
		echo -n
	    elif [ $i = "system" ]; then
		echo -n
#	    elif [ $i = "QtPalmtop" ]; then
#	        for q in 'ls $i';
#		do
#		    if [ $q = "QtPalmtop/lib" ]; then
#			echo -n
#		    else
#			rm -rf -- $q
#		    fi
#		done
	    #elif [ $i = "root" ]; then
	    elif [ "/home/$i" = "$HOME" ]; then
		rm -rf -- $i/*
	    else
		rm -rf -- $i
	    fi
	done
	# HDD support
	rm -rf /hdd2/Applications /hdd2/QtPalmtop /hdd2/usr
	if [ -f /etc/hotplug/usbdstorage.conf ]; then
	    rm -f /etc/hotplug/usbdstorage.conf
	fi
	exit_status=0
	;;
esac

exit $exit_status
