#include "usbconfig.h"

#include <qpushbutton.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>

#include <qpe/config.h>
#include <qpe/storage.h>
#include <qpe/resource.h>
#include <qpe/applnk.h>
#include <qpe/global.h>
#include <qpe/qpeapplication.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

static const char* devices[] = { "/dev/hda1", "dev/mmcda1" };
static const int DEVICE_CF = 0;
static const int DEVICE_SD = 1;

static const char* STORAGE_CONF = "/etc/hotplug/usbdstorage.conf";
static const char* USBD_FTYPE = "/etc/hotplug/usbd.ftype";

static const char* MODE_STORAGE = "storage";
static const char* MODE_NET = "net";

static int execute(const QString& arg)
{
	bool isroot = (getuid() == 0);
	int rc = system((!isroot ? "sudo " : "") + arg);
	return rc;
}

/* 
 *  Constructs a Example which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
UsbConfig::UsbConfig( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
	setWState(WState_Reserved1);
	setCaption(tr("USB Configuration"));
	
//    connect(quit, SIGNAL(clicked()), this, SLOT(goodBye()));

	QGridLayout* layout = new QGridLayout(this, 3, 2, AppLnk::smallIconSize(), AppLnk::smallIconSize());
	
	QLabel* l = new QLabel(tr("Make sure that Zaurus is removed from craddle <br> before switching USB mode."), this);
	l->setTextFormat(Qt::RichText);
	layout->addMultiCellWidget(l, 0, 0, 0, 1, Qt::AlignCenter | Qt::WordBreak);
	
	QRadioButton* mode_network = new QRadioButton(tr("Network"), this);
	layout->addWidget(mode_network, 1, 0);

	QImage img = Resource::loadImage("qtsamba").smoothScale(AppLnk::smallIconSize()*2, AppLnk::smallIconSize()*2);
	QPixmap pxPCLink;
	pxPCLink.convertFromImage(img);
	m_pcLink = new QPushButton(pxPCLink, tr("Launch PC Link"), this);
	layout->addWidget(m_pcLink, 1, 1);
	
	connect(m_pcLink, SIGNAL(clicked()), this, SLOT(pcLinkClicked()));

	QRadioButton* mode_storage = new QRadioButton(tr("Storage"), this);
	layout->addWidget(mode_storage, 2, 0);
	
	mode = new QButtonGroup(2, Qt::Horizontal, tr("USB Configuration"), this);
	mode->hide();
	mode->insert(mode_network);
	mode->insert(mode_storage);
	
	connect(mode, SIGNAL(clicked(int)), this, SLOT(modeChanged(int)));

	m_devices = new QComboBox(this);
	QPixmap pxCF = Resource::loadPixmap("CFDeviceS");
	QPixmap pxSD = Resource::loadPixmap("SDDeviceS");
	
	m_devices->insertItem(pxCF, tr("CF Card"));
	m_devices->insertItem(pxSD, tr("SD/MMC Card"));
	
	layout->addWidget(m_devices, 2, 1);

	load();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
UsbConfig::~UsbConfig()
{
    // no need to delete child widgets, Qt does it all for us
}

void UsbConfig::load()
{
	Config config("usbdstorage");
	m_device = config.readEntry("device", devices[DEVICE_CF]);
	config.setGroup("general");
	
	if (m_device == devices[DEVICE_CF])
		m_devices->setCurrentItem(DEVICE_CF);
	else
		m_devices->setCurrentItem(DEVICE_SD);
		
	// read usb mode
	QFile f(USBD_FTYPE);
	if (f.open(IO_ReadOnly))
	{
		QTextStream ts(&f);
		m_mode = ts.readLine();
	}
	
	if (m_mode == "")
		m_mode = MODE_NET;
		
	int id = m_mode == MODE_NET ? 0 : 1;
	mode->setButton(id);
	
	modeChanged(id);
}

void UsbConfig::save()
{
	m_device = devices[m_devices->currentItem()];

	Config config("usbdstorage");
	config.setGroup("general");
	config.writeEntry("device", m_device);
	
	// read usb mode
	execute("echo \"" + m_mode + "\" > " + USBD_FTYPE);

/*	
	QFile f(USBD_FTYPE);
	if (f.open(IO_WriteOnly))
	{
		QTextStream ts(&f);
		ts << m_mode;
	}
*/

	if (m_mode == MODE_STORAGE)
	{	
		execute("echo \"" + m_device + "\" > " + STORAGE_CONF);
/*
		f.setName(STORAGE_CONF);
		if (f.open(IO_WriteOnly))
		{
			QTextStream ts(&f);
			ts << m_device;
		}
		
*/
		start_storage();

	}
	else
	{
		execute(QString("rm -f ") + STORAGE_CONF);
		start_net();
	}

//	execute("/etc/rc.d/init.d/usb restart");	

	
}

void UsbConfig::start_net()
{
    execute("/sbin/rmmod sa1100_bi");
    execute("/sbin/rmmod storage_fd ");
    execute("/sbin/rmmod usbdcore");
    
    execute("/sbin/insmod usbdcore");
    execute("/sbin/insmod net_fd");
    execute("/sbin/insmod sa1100_bi");
    
    execute("mount " + m_device);
}

void UsbConfig::start_storage()
{
    execute("umount " + m_device);

    execute("/sbin/rmmod sa1100_bi");
    execute("/sbin/rmmod net_fd ");
    execute("/sbin/rmmod usbdcore");
    
    execute("/sbin/insmod usbdcore");
    execute("/sbin/insmod storage_fd storage_device=" + m_device);
    execute("/sbin/insmod sa1100_bi");
}
 
void UsbConfig::modeChanged(int newMode)
{
    m_mode = (newMode == 0 ? MODE_NET : MODE_STORAGE);
	m_devices->setEnabled(m_mode == MODE_STORAGE);
	m_pcLink->setEnabled(m_mode == MODE_NET);
}

void UsbConfig::pcLinkClicked()
{
    Global::execute("qtsamba");
}

void UsbConfig::reject()
{
	close();
	qApp->closeAllWindows();
	qApp->quit();
	exit(0);
}


void UsbConfig::accept()
{
    save();
	close();
	qApp->closeAllWindows();
	qApp->quit();
	exit(0);
}

