#ifndef USB_CONFIG_H
#define USB_CONFIG_H

#include <qwidget.h>

#include <qstring.h>

class QComboBox;
class QButtonGroup;
class QPushButton;

class UsbConfig : public QWidget
{ 
	Q_OBJECT

public:
	UsbConfig( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~UsbConfig();

private:
	QComboBox* m_devices;
	QButtonGroup* mode;
	QPushButton* m_pcLink;

	QString m_mode;
	QString m_device;

	void save();
	void load();
	
	void start_net();
	void start_storage();
  
private slots:
	void accept();
	void reject();
	
	void modeChanged(int newMode);
	void pcLinkClicked();
};

#endif // USBCONFIG_H
