/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;

public abstract class Representation {
    private static Hashtable representations = new Hashtable();
    public static final Representation ASCII = new AsciiRepresentation();
    public static final Representation IMAGE = new ImageRepresentation();
    private String name;
    private char code;

    public static Representation get(char code) {
        return (Representation)representations.get(new Character(code));
    }

    protected Representation(String name, char code) {
        this.name = name;
        this.code = code;
        representations.put(new Character(code), this);
    }

    public final String getName() {
        return this.name;
    }

    public final char getCode() {
        return this.code;
    }

    public abstract InputStream getInputStream(Socket var1) throws IOException;

    public abstract OutputStream getOutputStream(Socket var1) throws IOException;

    public abstract long sizeOf(File var1) throws IOException;
}

