/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Server
extends Frame
implements ActionListener {
    public static final String VERSION = "0.4";
    public static final int SERVER_PORT = 21;
    public static final int SERVER_DATA_PORT = 20;
    private int port;
    public static String myAddress = null;
    boolean running = true;
    static TextArea text;

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            myAddress = args[0];
        }
        Server server = new Server(21);
        server.start();
    }

    public Server(int port) {
        this.configure();
        this.port = port;
        this.setTitle("FTP 9500");
        this.setLayout(new BorderLayout());
        text = new TextArea();
        int size = System.getProperty("os.name").toLowerCase().startsWith("epoc") ? 8 : 12;
        text.setFont(new Font("Monospaced", 0, size));
        this.add("Center", text);
        this.addWindowListener(new Goodbye());
        this.addMenues();
        this.pack();
        this.setVisible(true);
    }

    private void addMenues() {
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        Menu menu = new Menu("Settings");
        mb.add(menu);
        MenuItem mi = new MenuItem("Set root...");
        mi.setActionCommand("root");
        mi.addActionListener(this);
        menu.add(mi);
        mi = new MenuItem("Enable debug mode");
        mi.setActionCommand("debug");
        mi.addActionListener(this);
        menu.add(mi);
    }

    public void actionPerformed(ActionEvent a) {
        String comm = a.getActionCommand();
        if (comm.equals("root")) {
            ServerPI.baseDir = MessageBox.askString(this, "Set root to", ServerPI.baseDir);
            Logger.log(6, "Setting root to " + ServerPI.baseDir);
        } else if (comm.equals("debug")) {
            Logger.setPriority(7);
        }
    }

    private void start() throws Exception {
        ServerSocket serverSocket = new ServerSocket(this.port);
        InetAddress address = null;
        try {
            if (myAddress == null) {
                address = InetAddress.getLocalHost();
                myAddress = address.getHostAddress();
            }
            if (myAddress.equals("127.0.0.1")) {
                myAddress = MessageBox.askString(this, "Cannot determine IP, please enter", myAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        text.append("FTP Server for Nokia 9500 Version 0.4 written by Ryan Heise\r\nand ported to the Nokia 9500 by Andreas Garzotto.\r\nServer address is: " + myAddress + "\r\n" + "Root is " + ServerPI.baseDir + "\r\n\r\n");
        text.setCaretPosition(999999999);
        while (this.running) {
            Socket clientSocket = serverSocket.accept();
            ServerPI pi = new ServerPI(clientSocket);
            new Thread(pi).start();
        }
    }

    public void service(Socket socket) throws Exception {
        ServerPI pi = new ServerPI(socket);
        pi.run();
    }

    private void configure() {
        String priorityStr = "INFO";
        String[] priorityNames = Logger.priorityNames;
        int priority = -1;
        int i = 0;
        while (i < priorityNames.length) {
            if (priorityNames[i].equals(priorityStr)) {
                priority = i;
                break;
            }
            ++i;
        }
        Logger.setPriority(priority);
    }

    private class Goodbye
    extends WindowAdapter {
        Goodbye() {
        }

        public void windowClosing(WindowEvent e) {
            Server.this.running = false;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Server.this.dispose();
            System.exit(0);
        }
    }
}

