/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ServerDTP {
    public boolean pasv = false;
    private ServerPI serverPI;
    private String dataHost;
    private int dataPort = -1;
    private TransmissionMode transmissionMode = TransmissionMode.STREAM;
    private Representation representation = Representation.ASCII;

    public ServerDTP(ServerPI serverPI) {
        this.serverPI = serverPI;
    }

    public void setTransmissionMode(TransmissionMode transmissionMode) {
        this.transmissionMode = transmissionMode;
    }

    public void setDataStructure(char stru) {
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public void setDataPort(String host, int port) {
        this.dataHost = host;
        this.dataPort = port;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int receiveFile(String path) throws CommandException {
        int reply = 0;
        FileOutputStream fos = null;
        Socket dataSocket = null;
        ServerSocket sSocket = null;
        try {
            try {
                File file = new File(path);
                if (file.exists()) {
                    throw new CommandException(550, "File exists in that location.");
                }
                fos = new FileOutputStream(file);
                if (this.dataPort == -1) {
                    throw new CommandException(500, "Can't establish data connection: no PORT specified.");
                }
                if (this.pasv) {
                    sSocket = new ServerSocket(this.dataPort);
                    dataSocket = sSocket.accept();
                } else {
                    dataSocket = new Socket(this.dataHost, this.dataPort);
                }
                this.serverPI.reply(150, "Opening " + this.representation.getName() + " mode data connection.");
                this.transmissionMode.receiveFile(dataSocket, fos, this.representation);
                reply = this.serverPI.reply(226, "Transfer complete.");
            }
            catch (ConnectException e) {
                throw new CommandException(425, "Can't open data connection.");
            }
            catch (IOException e) {
                throw new CommandException(550, "Can't write to file");
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                if (dataSocket != null) {
                    dataSocket.close();
                }
                if (sSocket != null) {
                    sSocket.close();
                }
                this.pasv = false;
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        try {}
        catch (IOException e) {
            return reply;
        }
        if (fos != null) {
            fos.close();
        }
        if (dataSocket != null) {
            dataSocket.close();
        }
        if (sSocket != null) {
            sSocket.close();
        }
        this.pasv = false;
        return reply;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendFile(String path) throws CommandException {
        int reply = 0;
        FileInputStream fis = null;
        Socket dataSocket = null;
        ServerSocket sSocket = null;
        try {
            try {
                File file = new File(path);
                if (!file.isFile()) {
                    throw new CommandException(550, "Not a plain file.");
                }
                fis = new FileInputStream(file);
                if (this.dataPort == -1) {
                    throw new CommandException(500, "Can't establish data connection: no PORT specified.");
                }
                if (this.pasv) {
                    sSocket = new ServerSocket(this.dataPort);
                    dataSocket = sSocket.accept();
                } else {
                    dataSocket = new Socket(this.dataHost, this.dataPort);
                }
                this.serverPI.reply(150, "Opening " + this.representation.getName() + " mode data connection.");
                this.transmissionMode.sendFile(fis, dataSocket, this.representation);
                reply = this.serverPI.reply(226, "Transfer complete.");
            }
            catch (FileNotFoundException e) {
                Logger.log(7, "No such file: " + e);
                throw new CommandException(550, "No such file.");
            }
            catch (ConnectException e) {
                throw new CommandException(425, "Can't open data connection.");
            }
            catch (IOException e) {
                Logger.log(7, "Not a regular file: " + e);
                throw new CommandException(553, "Not a regular file.");
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (dataSocket != null) {
                    dataSocket.close();
                }
                if (sSocket != null) {
                    sSocket.close();
                }
                this.pasv = false;
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var7_12 = null;
        }
        try {}
        catch (IOException e) {
            return reply;
        }
        if (fis != null) {
            fis.close();
        }
        if (dataSocket != null) {
            dataSocket.close();
        }
        if (sSocket != null) {
            sSocket.close();
        }
        this.pasv = false;
        return reply;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendNameList(String path) throws CommandException {
        int reply = 0;
        Socket dataSocket = null;
        ServerSocket sSocket = null;
        try {
            try {
                File dir = new File(path);
                String[] fileNames = dir.list();
                Representation representation = Representation.ASCII;
                if (this.pasv) {
                    sSocket = new ServerSocket(this.dataPort);
                    dataSocket = sSocket.accept();
                } else {
                    dataSocket = new Socket(this.dataHost, this.dataPort);
                }
                PrintWriter writer = new PrintWriter(representation.getOutputStream(dataSocket));
                this.serverPI.reply(150, "Opening " + representation.getName() + " mode data connection.");
                int i = 0;
                while (true) {
                    block16: {
                        if (i < fileNames.length) break block16;
                        writer.flush();
                        reply = this.serverPI.reply(226, "Transfer complete.");
                        break;
                    }
                    writer.print(fileNames[i]);
                    writer.print('\n');
                    ++i;
                }
            }
            catch (ConnectException e) {
                throw new CommandException(425, "Can't open data connection.");
            }
            catch (Exception e) {
                throw new CommandException(550, "No such directory.");
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (dataSocket != null) {
                    dataSocket.close();
                }
                if (sSocket != null) {
                    sSocket.close();
                }
                this.pasv = false;
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (IOException e) {
            return reply;
        }
        if (dataSocket != null) {
            dataSocket.close();
        }
        if (sSocket != null) {
            sSocket.close();
        }
        this.pasv = false;
        return reply;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendList(String path) throws CommandException {
        int reply = 0;
        Socket dataSocket = null;
        ServerSocket sSocket = null;
        try {
            try {
                File dir = new File(path);
                String[] fileNames = dir.list();
                int numFiles = fileNames != null ? fileNames.length : 0;
                Representation representation = Representation.ASCII;
                if (this.pasv) {
                    sSocket = new ServerSocket(this.dataPort);
                    Logger.log(7, "Waiting for connection on " + this.dataPort);
                    dataSocket = sSocket.accept();
                    Logger.log(7, "Got connection on " + this.dataPort);
                } else {
                    dataSocket = new Socket(this.dataHost, this.dataPort);
                }
                PrintWriter writer = new PrintWriter(representation.getOutputStream(dataSocket));
                this.serverPI.reply(150, "Opening " + representation.getName() + " mode data connection.");
                writer.print("total " + numFiles + "\n");
                int i = 0;
                while (true) {
                    block16: {
                        if (i < numFiles) break block16;
                        writer.flush();
                        reply = this.serverPI.reply(226, "Transfer complete.");
                        break;
                    }
                    String fileName = fileNames[i];
                    File file = new File(dir, fileName);
                    this.listFile(file, writer);
                    ++i;
                }
            }
            catch (ConnectException e) {
                throw new CommandException(425, "Can't open data connection.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CommandException(550, "No such directory.");
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                if (dataSocket != null) {
                    dataSocket.close();
                }
                if (sSocket != null) {
                    sSocket.close();
                }
                this.pasv = false;
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var13_17 = null;
        }
        try {}
        catch (IOException e) {
            return reply;
        }
        if (dataSocket != null) {
            dataSocket.close();
        }
        if (sSocket != null) {
            sSocket.close();
        }
        this.pasv = false;
        return reply;
    }

    private void listFile(File file, PrintWriter writer) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd hh:mm");
        Date date = new Date(file.lastModified());
        String dateStr = dateFormat.format(date);
        if (dateStr.startsWith("Mrz")) {
            dateStr = "Mar" + dateStr.substring(3);
        }
        dateStr = dateStr.replace('k', 'c');
        dateStr = dateStr.replace('i', 'y');
        dateStr = dateStr.replace('z', 'c');
        long size = file.length();
        String sizeStr = Long.toString(size);
        int sizePadLength = Math.max(8 - sizeStr.length(), 0);
        String sizeField = String.valueOf(ServerDTP.pad(sizePadLength)) + sizeStr;
        writer.print(file.isDirectory() ? (char)'d' : '-');
        writer.print("rwxrwxrwx");
        writer.print(" ");
        writer.print("   1");
        writer.print(" ");
        writer.print("ftp     ");
        writer.print(" ");
        writer.print("ftp     ");
        writer.print(" ");
        writer.print(sizeField);
        writer.print(" ");
        writer.print(dateStr);
        writer.print(" ");
        writer.print(file.getName());
        writer.print('\n');
    }

    private static String pad(int length) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < length) {
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }
}

