/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;

public class ServerPI
implements Runnable {
    private Socket clientSocket;
    private InputStreamReader reader;
    private PrintWriter writer;
    private ServerDTP dtp;
    private String username;
    private String password;
    public static String baseDir = "C:";
    private String currentDir = "/";
    String fromFile = null;

    public ServerPI(Socket clientSocket) throws IOException {
        this.clientSocket = clientSocket;
        this.reader = new InputStreamReader(clientSocket.getInputStream());
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(clientSocket.getOutputStream()), true);
        this.dtp = new ServerDTP(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.clientLoop();
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.log(0, "clientLoop failed: " + e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                this.clientSocket.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.clientSocket.close();
    }

    private static String getLine(InputStreamReader in) throws Exception {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch;
            try {
                ch = in.read();
            }
            catch (Exception e) {
                Logger.log(3, "Problem reading command channel: " + e.getClass());
                return null;
            }
            if (ch <= 0) break;
            if (ch == 13 || ch == 10) {
                if (buf.length() <= 0) continue;
                break;
            }
            if (ch < 32) continue;
            buf.append((char)ch);
        }
        return buf.toString();
    }

    private void clientLoop() throws Exception {
        Logger.log(6, "New session from " + this.clientSocket.getInetAddress().getHostName());
        this.reply(220, "FTP 9500 server (Version 0.4) ready.");
        String line = null;
        while ((line = ServerPI.getLine(this.reader)) != null) {
            if (line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line);
            String command = st.nextToken().toLowerCase();
            if ("PASS".equalsIgnoreCase(command)) {
                Logger.log(7, "PASS ********");
            } else {
                Logger.log(7, line);
            }
            try {
                int code = 500;
                if (command.equals("user")) {
                    code = this.handle_user(line, st);
                } else if (command.equals("pass")) {
                    code = this.handle_pass(line, st);
                } else if (command.equals("quit")) {
                    code = this.handle_quit(line, st);
                } else if (command.equals("cwd")) {
                    code = this.handle_cwd(line, st);
                } else if (command.equals("pwd")) {
                    code = this.handle_pwd(line, st);
                } else if (command.equals("xpwd")) {
                    code = this.handle_pwd(line, st);
                } else if (command.equals("pasv")) {
                    code = this.handle_pasv(line, st);
                } else if (command.equals("type")) {
                    code = this.handle_type(line, st);
                } else if (command.equals("help")) {
                    code = this.handle_help(line, st);
                } else if (command.equals("noop")) {
                    code = this.handle_noop(line, st);
                } else if (command.equals("list")) {
                    code = this.handle_list(line, st);
                } else if (command.equals("nlst")) {
                    code = this.handle_nlst(line, st);
                } else if (command.equals("retr")) {
                    code = this.handle_retr(line, st);
                } else if (command.equals("stor")) {
                    code = this.handle_stor(line, st);
                } else if (command.equals("port")) {
                    code = this.handle_port(line, st);
                } else if (command.equals("type")) {
                    code = this.handle_type(line, st);
                } else if (command.equals("syst")) {
                    code = this.handle_syst(line, st);
                } else if (command.equals("size")) {
                    code = this.handle_size(line, st);
                } else if (command.equals("dele")) {
                    code = this.handle_dele(line, st);
                } else if (command.equals("rnfr")) {
                    code = this.handle_rnfr(line, st);
                } else if (command.equals("rnto")) {
                    code = this.handle_rnto(line, st);
                } else if (command.equals("appe")) {
                    code = this.handle_appe(line, st);
                } else if (command.equals("allo")) {
                    code = this.handle_allo(line, st);
                } else if (command.equals("rest")) {
                    code = this.handle_rest(line, st);
                } else if (command.equals("stou")) {
                    code = this.handle_stou(line, st);
                } else if (command.equals("mode")) {
                    code = this.handle_mode(line, st);
                } else if (command.equals("cdup")) {
                    code = this.handle_cdup(line, st);
                } else if (command.equals("smnt")) {
                    code = this.handle_smnt(line, st);
                } else if (command.equals("abor")) {
                    code = this.handle_abor(line, st);
                } else if (command.equals("rmd")) {
                    code = this.handle_rmd(line, st);
                } else if (command.equals("mkd")) {
                    code = this.handle_mkd(line, st);
                } else if (command.equals("site")) {
                    code = this.handle_site(line, st);
                } else if (command.equals("stat")) {
                    code = this.handle_stat(line, st);
                } else if (command.equals("help")) {
                    code = this.handle_help(line, st);
                } else if (command.equals("mdtm")) {
                    code = this.handle_mdtm(line, st);
                } else {
                    throw new NoSuchMethodException();
                }
                if (code != 221) continue;
                return;
            }
            catch (CommandException ce) {
                Logger.log(3, ce.getText());
                this.reply(ce.getCode(), ce.getText());
            }
            catch (NoSuchElementException e1) {
                Logger.log(3, "Unknown command " + line);
                this.reply(500, "'" + line + "': command not understood.");
            }
            catch (NoSuchMethodException e) {
                Logger.log(3, "Unknown command " + line);
                this.reply(500, "'" + line + "': command not understood.");
            }
            catch (Exception e) {
                Logger.log(3, "Problem " + e.getClass());
                Logger.log(3, "Exception invoking " + command + " command handler: " + e);
                e.printStackTrace();
            }
        }
    }

    public int handle_user(String line, StringTokenizer st) {
        this.username = st.nextToken();
        if (this.username.equals("ftp") || this.username.equals("anonymous")) {
            this.password = "ftp";
            return this.reply(230, "User " + this.username + " logged in.");
        }
        return this.reply(331, "Password required for " + this.username + ".");
    }

    public int handle_pass(String line, StringTokenizer st) throws CommandException {
        if (this.username == null) {
            throw new CommandException(503, "Login with USER first.");
        }
        String password = null;
        password = st.hasMoreTokens() ? st.nextToken() : "";
        this.password = password;
        return this.reply(230, "User " + this.username + " logged in.");
    }

    public int handle_acct(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_cwd(String line, StringTokenizer st) throws CommandException {
        File file;
        this.checkLogin();
        String arg = st.nextToken();
        while (st.hasMoreTokens()) {
            arg = String.valueOf(arg) + " " + st.nextToken();
        }
        String newDir = arg;
        if (newDir.length() == 0) {
            newDir = "/";
        }
        if (!(file = new File(this.createNativePath(newDir = this.resolvePath(newDir)))).exists()) {
            throw new CommandException(550, String.valueOf(arg) + ": no such directory");
        }
        if (!file.isDirectory()) {
            throw new CommandException(550, String.valueOf(arg) + ": not a directory");
        }
        this.currentDir = newDir;
        Logger.log(7, "new cwd = " + this.currentDir);
        return this.reply(250, "CWD command successful.");
    }

    public int handle_cdup(String line, StringTokenizer st) throws CommandException {
        return this.handle_cwd(line, st);
    }

    public int handle_smnt(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_quit(String line, StringTokenizer st) {
        this.username = null;
        this.password = null;
        Logger.log(6, "Terminating session with " + this.clientSocket.getInetAddress().getHostName());
        return this.reply(221, "Goodbye.");
    }

    public int handle_rein(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        this.username = null;
        this.password = null;
        this.currentDir = "/";
        this.dtp = new ServerDTP(this);
        return this.reply(220, "Service ready for new user.");
    }

    public int handle_port(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String portStr = st.nextToken();
        st = new StringTokenizer(portStr, ",");
        String h1 = st.nextToken();
        String h2 = st.nextToken();
        String h3 = st.nextToken();
        String h4 = st.nextToken();
        int p1 = Integer.parseInt(st.nextToken());
        int p2 = Integer.parseInt(st.nextToken());
        String dataHost = String.valueOf(h1) + "." + h2 + "." + h3 + "." + h4;
        int dataPort = p1 << 8 | p2;
        this.dtp.setDataPort(dataHost, dataPort);
        return this.reply(200, "PORT command successful.");
    }

    public int handle_pasv(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        Random rand = new Random(System.currentTimeMillis());
        int dataport = 8100 + rand.nextInt(900);
        this.dtp.setDataPort("otherHist", dataport);
        this.dtp.pasv = true;
        try {
            StringTokenizer tok = new StringTokenizer(Server.myAddress);
            int h1 = Integer.parseInt(tok.nextToken("."));
            int h2 = Integer.parseInt(tok.nextToken("."));
            int h3 = Integer.parseInt(tok.nextToken("."));
            int h4 = Integer.parseInt(tok.nextToken("."));
            int p1 = dataport >> 8;
            int p2 = dataport & 0xFF;
            String repl = "(" + h1 + "," + h2 + "," + h3 + "," + h4 + "," + p1 + "," + p2 + ")";
            Logger.log(7, "Send PASV " + repl);
            return this.reply(227, "Entering Passive Mode " + repl);
        }
        catch (Exception e) {
            return this.reply(500, "Cannot retrieve my IP address.");
        }
    }

    public int handle_type(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken().toUpperCase();
        if (arg.length() != 1) {
            throw new CommandException(500, "TYPE: invalid argument '" + arg + "'");
        }
        char code = arg.charAt(0);
        Representation representation = Representation.get(code);
        if (representation == null) {
            throw new CommandException(500, "TYPE: invalid argument '" + arg + "'");
        }
        this.dtp.setRepresentation(representation);
        return this.reply(200, "Type set to " + arg);
    }

    public int handle_stru(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken().toUpperCase();
        try {
            if (arg.length() != 1) {
                throw new Exception();
            }
            char stru = arg.charAt(0);
            switch (stru) {
                case 'F': {
                    this.dtp.setDataStructure(stru);
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(500, "STRU: invalid argument '" + arg + "'");
        }
        return this.reply(200, "STRU " + arg + " ok.");
    }

    public int handle_mode(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken().toUpperCase();
        if (arg.length() != 1) {
            throw new CommandException(500, "MODE: invalid argument '" + arg + "'");
        }
        char code = arg.charAt(0);
        TransmissionMode mode = TransmissionMode.get(code);
        if (mode == null) {
            throw new CommandException(500, "MODE: invalid argument '" + arg + "'");
        }
        this.dtp.setTransmissionMode(mode);
        return this.reply(200, "MODE " + arg + " ok.");
    }

    public int handle_retr(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String path = null;
        try {
            path = line.substring(5);
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
        path = this.createNativePath(path);
        Logger.log(6, "Downloading: " + path);
        return this.dtp.sendFile(path);
    }

    public int handle_stor(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String path = null;
        try {
            path = line.substring(5);
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
        path = this.createNativePath(path);
        Logger.log(6, "Uploading: " + path);
        return this.dtp.receiveFile(path);
    }

    public int handle_stou(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_appe(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_allo(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_rest(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_rnfr(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        this.fromFile = line.substring(5);
        this.fromFile = this.fromFile = this.createNativePath(this.fromFile);
        return this.reply(350, "RNFR " + this.fromFile + " ok.");
    }

    public int handle_rnto(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String toFile = line.substring(5);
        toFile = this.createNativePath(toFile);
        if (!new File(this.fromFile).renameTo(new File(toFile))) {
            throw new CommandException(500, "Renaming failed.");
        }
        return this.reply(200, "RNTO " + toFile + " ok.");
    }

    public int handle_abor(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_dele(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken();
        String filePath = this.resolvePath(arg);
        File file = new File(this.createNativePath(filePath));
        if (!file.exists()) {
            throw new CommandException(550, String.valueOf(arg) + ": file does not exist");
        }
        if (!file.delete()) {
            throw new CommandException(550, String.valueOf(arg) + ": could not delete file");
        }
        return this.reply(250, "DELE command successful.");
    }

    public int handle_rmd(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken();
        String dirPath = this.resolvePath(arg);
        File dir = new File(this.createNativePath(dirPath));
        if (!dir.exists()) {
            throw new CommandException(550, String.valueOf(arg) + ": directory does not exist");
        }
        if (!dir.isDirectory()) {
            throw new CommandException(550, String.valueOf(arg) + ": not a directory");
        }
        if (!dir.delete()) {
            throw new CommandException(550, String.valueOf(arg) + ": could not remove directory");
        }
        return this.reply(250, "RMD command successful.");
    }

    public int handle_mkd(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken();
        String dirPath = this.resolvePath(arg);
        File dir = new File(this.createNativePath(dirPath));
        if (dir.exists()) {
            throw new CommandException(550, String.valueOf(arg) + ": file exists");
        }
        if (!dir.mkdir()) {
            throw new CommandException(550, String.valueOf(arg) + ": directory could not be created");
        }
        return this.reply(257, "\"" + dirPath + "\" directory created");
    }

    public int handle_pwd(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        return this.reply(257, "\"" + this.currentDir + "\"");
    }

    public int handle_list(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String path = null;
        path = st.hasMoreTokens() ? st.nextToken() : this.currentDir;
        path = this.createNativePath(path);
        return this.dtp.sendList(path);
    }

    public int handle_nlst(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String path = null;
        path = st.hasMoreTokens() ? st.nextToken() : this.currentDir;
        path = this.createNativePath(path);
        return this.dtp.sendNameList(path);
    }

    public int handle_site(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_syst(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        return this.reply(215, "UNIX Type: A");
    }

    public int handle_stat(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_help(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        throw new CommandException(500, "'" + line + "': command not supported.");
    }

    public int handle_noop(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        return this.reply(200, "NOOP command successful.");
    }

    public int handle_size(String line, StringTokenizer st) throws CommandException {
        long size;
        this.checkLogin();
        String arg = line.substring(5);
        String path = this.resolvePath(arg);
        File file = new File(this.createNativePath(path));
        if (!file.exists()) {
            throw new CommandException(550, String.valueOf(arg) + ": no such file");
        }
        if (!file.isFile()) {
            throw new CommandException(550, String.valueOf(arg) + ": not a plain file");
        }
        Representation representation = this.dtp.getRepresentation();
        try {
            size = representation.sizeOf(file);
        }
        catch (IOException e) {
            throw new CommandException(550, e.getMessage());
        }
        return this.reply(213, "" + size);
    }

    public int handle_mdtm(String line, StringTokenizer st) throws CommandException {
        this.checkLogin();
        String arg = st.nextToken();
        String path = this.resolvePath(arg);
        File file = new File(this.createNativePath(path));
        if (!file.exists()) {
            throw new CommandException(550, String.valueOf(arg) + ": no such file");
        }
        Date date = new Date(file.lastModified());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        String dateStr = dateFormat.format(date);
        return this.reply(213, dateStr);
    }

    int reply(int code, String text) {
        this.writer.println(String.valueOf(code) + " " + text);
        return code;
    }

    String createNativePath(String ftpPath) {
        String path = null;
        path = ftpPath.charAt(0) == '/' ? String.valueOf(baseDir) + ftpPath : String.valueOf(baseDir) + this.currentDir + "/" + ftpPath;
        Logger.log(7, "createNativePath(" + ftpPath + ") = " + path);
        return path;
    }

    String resolvePath(String path) {
        if (path.charAt(0) != '/') {
            path = String.valueOf(this.currentDir) + "/" + path;
        }
        StringTokenizer pathSt = new StringTokenizer(path, "/");
        Stack<String> segments = new Stack<String>();
        while (pathSt.hasMoreTokens()) {
            String segment = pathSt.nextToken();
            if (segment.equals("..")) {
                if (segments.empty()) continue;
                segments.pop();
                continue;
            }
            if (segment.equals(".")) continue;
            segments.push(segment);
        }
        StringBuffer pathBuf = new StringBuffer("/");
        Enumeration segmentsEn = segments.elements();
        while (segmentsEn.hasMoreElements()) {
            pathBuf.append(segmentsEn.nextElement());
            if (!segmentsEn.hasMoreElements()) continue;
            pathBuf.append("/");
        }
        return pathBuf.toString();
    }

    void checkLogin() throws CommandException {
        if (this.password == null) {
            throw new CommandException(530, "Please login with USER and PASS.");
        }
    }
}

