//==========================================================================
//
//      dev/DM9161A.c
//
//      Ethernet transceiver (PHY) support 
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2003 Gary Thomas
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    John Eigelaar
// Contributors: Gary Thomas
// Date:         2006-12-07
// Purpose:      
// Description:  Support for Davicom DM9161A PHY
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/system.h>
#include <pkgconf/devs_eth_phy.h>

#include <cyg/infra/cyg_type.h>

#include <cyg/hal/hal_arch.h>
#include <cyg/hal/drv_api.h>
#include <cyg/hal/hal_if.h>
#include <cyg/hal/hal_tables.h>

#include <cyg/io/eth_phy.h>
#include <cyg/io/eth_phy_dev.h>

#define DM9161A_BMSR 0x01
#define DM9161A_BMSR_ANEG_COMP (1<<5)
#define DM9161A_BMSR_LINK (1<<2)

#define DM9161A_BMCR 0x00

#define DM9161A_DSCSR 17
#define DM9161A_DSCSR_100FDX (1<<15)
#define DM9161A_DSCSR_100HDX (1<<14)
#define DM9161A_DSCSR_10FDX (1<<13)
#define DM9161A_DSCSR_10HDX (1<<12)

static bool dm9161a_stat(eth_phy_access_t *f, int *state)
{
   unsigned short phy_state;
   int tries;

   *state = 0;
   // Read negotiated state

   if (_eth_phy_read(f, DM9161A_BMSR, f->phy_addr, &phy_state))
   {
      if ((phy_state & DM9161A_BMSR_ANEG_COMP) == 0)
      {
         eth_phy_printf("... waiting for auto-negotiation");
         for (tries = 0; tries < CYGINT_DEVS_ETH_PHY_AUTO_NEGOTIATION_TIME;  
              tries++)
         {
            if (_eth_phy_read(f, DM9161A_BMSR, f->phy_addr, &phy_state))
            {
               if ((phy_state & DM9161A_BMSR_ANEG_COMP) != 0)
               {
                  break;
               }
            }
            CYGACC_CALL_IF_DELAY_US(1000000);   // 1 second
            eth_phy_printf(".");
         }
         eth_phy_printf("\n");
      }
      if ((phy_state & DM9161A_BMSR_ANEG_COMP) != 0)
      {
         *state = 0;
         if (!_eth_phy_read(f, DM9161A_DSCSR, f->phy_addr, &phy_state))
            return false;

         if (phy_state & 0xF000)
         {
           *state |= ETH_PHY_STAT_LINK; 
         }
         if ((phy_state & DM9161A_DSCSR_100FDX) || 
             (phy_state & DM9161A_DSCSR_100HDX))
         {
            *state |= ETH_PHY_STAT_100MB; 
         }
         if ((phy_state & DM9161A_DSCSR_100FDX) || 
             (phy_state & DM9161A_DSCSR_10FDX))
         {
            *state |= ETH_PHY_STAT_FDX; 
         }

         return (true);
      }
   }
   return (false);
}

_eth_phy_dev("Davicom DM9161A", 0x0181B8A0, dm9161a_stat)
