/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.cache;

import org.logicprobe.LogicMail.cache.CacheReader;
import org.logicprobe.LogicMail.cache.CacheWriter;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.util.SerializableHashtable;

public class AccountCache {
    private String _acctName;

    public AccountCache(String acctName) {
        this._acctName = acctName;
    }

    public String getAcctName() {
        return this._acctName;
    }

    public void setAcctName(String acctName) {
        this._acctName = acctName;
    }

    public void saveFolderTree(FolderTreeItem folderRoot) {
        String key = "acct_" + this._acctName + "_folders";
        CacheWriter writer = new CacheWriter("LogicMail_acct_" + Integer.toString(key.hashCode()));
        writer.addItem(folderRoot);
        writer.store();
    }

    public FolderTreeItem loadFolderTree() {
        String key = "acct_" + this._acctName + "_folders";
        CacheReader reader = new CacheReader("LogicMail_acct_" + Integer.toString(key.hashCode()));
        reader.load();
        if (reader.getNumItems() < 1) {
            return null;
        }
        FolderTreeItem folderRoot = new FolderTreeItem();
        reader.getItem(0, folderRoot);
        return folderRoot;
    }

    public void saveAccountMetadata(String key, SerializableHashtable metadata) {
        String writerKey = "acct_" + this._acctName + "_metadata_" + key;
        CacheWriter writer = new CacheWriter("LogicMail_acct_" + Integer.toString(writerKey.hashCode()));
        writer.addItem(metadata);
        writer.store();
    }

    public SerializableHashtable loadAccountMetadata(String key) {
        String readerKey = "acct_" + this._acctName + "_metadata_" + key;
        CacheReader reader = new CacheReader("LogicMail_acct_" + Integer.toString(readerKey.hashCode()));
        reader.load();
        if (reader.getNumItems() < 1) {
            return null;
        }
        SerializableHashtable hashtable = new SerializableHashtable();
        reader.getItem(0, hashtable);
        return hashtable;
    }
}

