/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.cache;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import org.logicprobe.LogicMail.util.Serializable;

public class CacheReader {
    String _storeName;
    Vector _storeList;

    public CacheReader(String storeName) {
        this._storeName = storeName;
        this._storeList = new Vector();
    }

    public int getNumItems() {
        return this._storeList.size();
    }

    public void getItem(int index, Serializable item) {
        ByteArrayInputStream buffer = new ByteArrayInputStream((byte[])this._storeList.elementAt(index));
        DataInputStream input = new DataInputStream(buffer);
        try {
            item.deserialize(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void load() {
        this._storeList.removeAllElements();
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)this._storeName, (boolean)false);
            if (store == null) {
                return;
            }
            int records = store.getNumRecords();
            for (int i = 1; i <= records; ++i) {
                this._storeList.addElement(store.getRecord(i));
            }
        }
        catch (RecordStoreNotFoundException exp) {
            return;
        }
        catch (RecordStoreException exp) {
            // empty catch block
        }
        try {
            if (store != null) {
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

