/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializableHashtable;

public class GlobalConfig
implements Serializable {
    private String fullname;
    private int retMsgCount;
    private boolean dispOrder;
    private int imapMaxMsgSize;
    private int imapMaxFolderDepth;
    private int popMaxLines;
    private String msgSignature;

    public GlobalConfig() {
        this.setDefaults();
    }

    public GlobalConfig(DataInputStream input) {
        try {
            this.deserialize(input);
        }
        catch (IOException ex) {
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.fullname = "";
        this.retMsgCount = 30;
        this.dispOrder = false;
        this.imapMaxMsgSize = 32768;
        this.imapMaxFolderDepth = 4;
        this.popMaxLines = 400;
        this.msgSignature = "";
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setRetMsgCount(int retMsgCount) {
        this.retMsgCount = retMsgCount;
    }

    public int getRetMsgCount() {
        return this.retMsgCount;
    }

    public void setDispOrder(boolean dispOrder) {
        this.dispOrder = dispOrder;
    }

    public boolean getDispOrder() {
        return this.dispOrder;
    }

    public int getImapMaxMsgSize() {
        return this.imapMaxMsgSize;
    }

    public void setImapMaxMsgSize(int imapMaxMsgSize) {
        this.imapMaxMsgSize = imapMaxMsgSize;
    }

    public int getImapMaxFolderDepth() {
        return this.imapMaxFolderDepth;
    }

    public void setImapMaxFolderDepth(int imapMaxFolderDepth) {
        this.imapMaxFolderDepth = imapMaxFolderDepth;
    }

    public int getPopMaxLines() {
        return this.popMaxLines;
    }

    public void setPopMaxLines(int popMaxLines) {
        this.popMaxLines = popMaxLines;
    }

    public String getMsgSignature() {
        return this.msgSignature;
    }

    public void setMsgSignature(String msgSignature) {
        this.msgSignature = msgSignature;
    }

    public void serialize(DataOutputStream output) throws IOException {
        SerializableHashtable table = new SerializableHashtable();
        table.put("global_fullname", this.fullname);
        table.put("global_retMsgCount", new Integer(this.retMsgCount));
        table.put("global_dispOrder", new Boolean(this.dispOrder));
        table.put("global_imapMaxMsgSize", new Integer(this.imapMaxMsgSize));
        table.put("global_imapMaxFolderDepth", new Integer(this.imapMaxFolderDepth));
        table.put("global_popMaxLines", new Integer(this.popMaxLines));
        table.put("global_msgSignature", this.msgSignature);
        table.serialize(output);
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.setDefaults();
        SerializableHashtable table = new SerializableHashtable();
        table.deserialize(input);
        Object value = table.get("global_fullname");
        if (value != null && value instanceof String) {
            this.fullname = (String)value;
        }
        if ((value = table.get("global_retMsgCount")) != null && value instanceof Integer) {
            this.retMsgCount = (Integer)value;
        }
        if ((value = table.get("global_dispOrder")) != null && value instanceof Boolean) {
            this.dispOrder = (Boolean)value;
        }
        if ((value = table.get("global_imapMaxMsgSize")) != null && value instanceof Integer) {
            this.imapMaxMsgSize = (Integer)value;
        }
        if ((value = table.get("global_imapMaxFolderDepth")) != null && value instanceof Integer) {
            this.imapMaxFolderDepth = (Integer)value;
        }
        if ((value = table.get("global_popMaxLines")) != null && value instanceof Integer) {
            this.popMaxLines = (Integer)value;
        }
        if ((value = table.get("global_msgSignature")) != null && value instanceof String) {
            this.msgSignature = (String)value;
        }
    }
}

