/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;

public class MailSettings {
    private static MailSettings instance;
    private GlobalConfig globalConfig = new GlobalConfig();
    private Vector accountConfigs = new Vector();

    private MailSettings() {
    }

    public static synchronized MailSettings getInstance() {
        if (instance == null) {
            instance = new MailSettings();
        }
        return instance;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public int getNumAccounts() {
        return this.accountConfigs.size();
    }

    public AccountConfig getAccountConfig(int index) {
        return (AccountConfig)this.accountConfigs.elementAt(index);
    }

    public void addAccountConfig(AccountConfig accountConfig) {
        this.accountConfigs.addElement(accountConfig);
    }

    public void removeAccountConfig(int index) {
        this.accountConfigs.removeElementAt(index);
    }

    public void saveSettings() {
        try {
            RecordStore.deleteRecordStore((String)"LogicMail_config");
        }
        catch (RecordStoreException exp) {
            // empty catch block
        }
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)"LogicMail_config", (boolean)true);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(buffer);
            try {
                this.globalConfig.serialize(output);
            }
            catch (IOException ex) {
                // empty catch block
            }
            byte[] byteArray = buffer.toByteArray();
            store.addRecord(byteArray, 0, byteArray.length);
            for (int i = 0; i < this.accountConfigs.size(); ++i) {
                buffer = new ByteArrayOutputStream();
                output = new DataOutputStream(buffer);
                try {
                    ((AccountConfig)this.accountConfigs.elementAt(i)).serialize(output);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                byteArray = buffer.toByteArray();
                store.addRecord(byteArray, 0, byteArray.length);
            }
        }
        catch (RecordStoreException exp) {
            // empty catch block
        }
        try {
            if (store != null) {
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void loadSettings() {
        RecordStore store;
        block9: {
            this.accountConfigs.removeAllElements();
            store = null;
            try {
                store = RecordStore.openRecordStore((String)"LogicMail_config", (boolean)false);
                int records = store.getNumRecords();
                if (records < 1) break block9;
                ByteArrayInputStream buffer = new ByteArrayInputStream(store.getRecord(1));
                DataInputStream input = new DataInputStream(buffer);
                try {
                    this.globalConfig.deserialize(input);
                }
                catch (IOException ex) {
                    this.globalConfig = new GlobalConfig();
                }
                if (records > 1) {
                    for (int i = 2; i <= store.getNumRecords(); ++i) {
                        buffer = new ByteArrayInputStream(store.getRecord(i));
                        input = new DataInputStream(buffer);
                        this.accountConfigs.addElement(new AccountConfig(input));
                    }
                }
            }
            catch (RecordStoreException exp) {
                // empty catch block
            }
        }
        try {
            if (store != null) {
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

