/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.util.Serializable;

public class FolderTreeItem
implements Serializable {
    private FolderTreeItem parent;
    private FolderTreeItem[] children;
    private String name;
    private String path;
    private String delim;
    private int msgCount;
    private int unseenCount;

    public FolderTreeItem(String name, String path, String delim) {
        this.parent = null;
        this.name = name;
        this.path = path;
        this.delim = delim;
        this.msgCount = -1;
        this.unseenCount = -1;
        this.children = null;
    }

    public FolderTreeItem(FolderTreeItem parent, String name, String path, String delim) {
        this.parent = parent;
        this.name = name;
        this.path = path;
        this.delim = delim;
        this.msgCount = -1;
        this.unseenCount = -1;
        this.children = null;
    }

    public FolderTreeItem() {
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeUTF(this.name);
        output.writeUTF(this.path);
        output.writeUTF(this.delim);
        output.writeInt(this.msgCount);
        if (this.children != null && this.children.length > 0) {
            output.writeInt(this.children.length);
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].serialize(output);
            }
        } else {
            output.writeInt(0);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.name = input.readUTF();
        this.path = input.readUTF();
        this.delim = input.readUTF();
        this.msgCount = input.readInt();
        int childCount = input.readInt();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                FolderTreeItem item = new FolderTreeItem();
                item.deserialize(input);
                item.parent = this;
                this.addChild(item);
            }
        }
    }

    public FolderTreeItem[] children() {
        return this.children;
    }

    public FolderTreeItem getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public void addChild(FolderTreeItem item) {
        if (this.children == null) {
            this.children = new FolderTreeItem[1];
            this.children[0] = item;
        } else {
            Arrays.add((Object[])this.children, (Object)item);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getDelim() {
        return this.delim;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public void setMsgCount(int msgCount) {
        this.msgCount = msgCount;
    }

    public int getUnseenCount() {
        return this.unseenCount;
    }

    public void setUnseenCount(int unseenCount) {
        this.unseenCount = unseenCount;
    }
}

