/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.mail.imap.ImapClient;
import org.logicprobe.LogicMail.mail.pop.PopClient;
import org.logicprobe.LogicMail.mail.smtp.SmtpClient;

public class MailClientFactory {
    private MailClientFactory() {
    }

    public static IncomingMailClient createMailClient(AccountConfig acctConfig) {
        GlobalConfig globalConfig = MailSettings.getInstance().getGlobalConfig();
        if (acctConfig.getServerType() == 0) {
            return new PopClient(globalConfig, acctConfig);
        }
        if (acctConfig.getServerType() == 1) {
            return new ImapClient(globalConfig, acctConfig);
        }
        return null;
    }

    public static OutgoingMailClient createOutgoingMailClient(AccountConfig acctConfig) {
        GlobalConfig globalConfig = MailSettings.getInstance().getGlobalConfig();
        return new SmtpClient(globalConfig, acctConfig);
    }
}

