/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.imap.ImapParser;
import org.logicprobe.LogicMail.mail.imap.ImapProtocol;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartFactory;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.util.Connection;

public class ImapClient
implements IncomingMailClient {
    private GlobalConfig globalConfig;
    private AccountConfig acctCfg;
    private Connection connection;
    private ImapProtocol imapProtocol;
    private String username;
    private String password;
    private boolean openStarted;
    private Hashtable capabilities;
    private String folderDelim = "";
    private ImapProtocol.Namespace nsPersonal;
    private FolderTreeItem activeMailbox = null;

    public ImapClient(GlobalConfig globalConfig, AccountConfig acctCfg) {
        this.acctCfg = acctCfg;
        this.globalConfig = globalConfig;
        this.connection = new Connection(acctCfg.getServerName(), acctCfg.getServerPort(), acctCfg.getServerSSL(), acctCfg.getDeviceSide());
        this.imapProtocol = new ImapProtocol(this.connection);
        this.username = acctCfg.getServerUser();
        this.password = acctCfg.getServerPass();
        this.openStarted = false;
    }

    public boolean open() throws IOException, MailException {
        try {
            Vector resp;
            if (!this.openStarted) {
                this.connection.open();
                this.activeMailbox = null;
                this.connection.receive();
                this.capabilities = this.imapProtocol.executeCapability();
                this.openStarted = true;
            }
            if (!this.imapProtocol.executeLogin(this.username, this.password)) {
                return false;
            }
            if (this.capabilities.containsKey("NAMESPACE")) {
                ImapProtocol.NamespaceResponse nsResponse = this.imapProtocol.executeNamespace();
                if (nsResponse.personal != null && nsResponse.personal.length > 0 && nsResponse.personal[0] != null && nsResponse.personal[0].delimiter != null && nsResponse.personal[0].prefix != null) {
                    this.nsPersonal = nsResponse.personal[0];
                    this.folderDelim = this.nsPersonal.delimiter;
                }
            }
            if (this.nsPersonal == null && (resp = this.imapProtocol.executeList("", "")).size() > 0) {
                this.folderDelim = ((ImapProtocol.ListResponse)resp.elementAt((int)0)).delim;
            }
            this.openStarted = false;
        }
        catch (MailException exp) {
            this.close();
            String msg = exp.getMessage();
            if (msg.startsWith("NO")) {
                msg = msg.substring(msg.indexOf(32) + 1);
            }
            throw new MailException(msg);
        }
        return true;
    }

    public void close() throws IOException, MailException {
        if (this.connection.isConnected()) {
            if (this.activeMailbox != null && !this.activeMailbox.equals("")) {
                this.imapProtocol.executeClose();
            }
            this.imapProtocol.executeLogout();
        }
        this.activeMailbox = null;
        this.connection.close();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public AccountConfig getAcctConfig() {
        return this.acctCfg;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasFolders() {
        return true;
    }

    public FolderTreeItem getFolderTree() throws IOException, MailException {
        FolderTreeItem rootItem = new FolderTreeItem("", "", this.folderDelim);
        this.getFolderTreeImpl(rootItem, 0);
        return rootItem;
    }

    private void getFolderTreeImpl(FolderTreeItem baseFolder, int depth) throws IOException, MailException {
        Vector respList = depth == 0 ? this.imapProtocol.executeList(baseFolder.getPath(), "%") : this.imapProtocol.executeList(baseFolder.getPath() + baseFolder.getDelim(), "%");
        int size = respList.size();
        for (int i = 0; i < size; ++i) {
            ImapProtocol.ListResponse resp = (ImapProtocol.ListResponse)respList.elementAt(i);
            if (!resp.canSelect) continue;
            FolderTreeItem childItem = this.getFolderItem(baseFolder, resp.name);
            baseFolder.addChild(childItem);
            if (resp.hasChildren) {
                if (depth + 1 >= this.globalConfig.getImapMaxFolderDepth()) continue;
                this.getFolderTreeImpl(childItem, depth + 1);
                continue;
            }
            if (depth != 0 || this.nsPersonal == null || !(resp.name + this.nsPersonal.delimiter).equals(this.nsPersonal.prefix) || this.globalConfig.getImapMaxFolderDepth() <= 1) continue;
            this.getFolderTreeImpl(childItem, depth + 1);
        }
    }

    public void refreshFolderStatus(FolderTreeItem root) throws IOException, MailException {
        int i;
        Vector folders = new Vector();
        this.flattenFolderTree(folders, root);
        int size = folders.size();
        String[] mboxpaths = new String[size];
        for (i = 0; i < size; ++i) {
            mboxpaths[i] = ((FolderTreeItem)folders.elementAt(i)).getPath();
        }
        ImapProtocol.StatusResponse[] response = this.imapProtocol.executeStatus(mboxpaths);
        for (i = 0; i < size; ++i) {
            FolderTreeItem item = (FolderTreeItem)folders.elementAt(i);
            item.setMsgCount(response[i].exists);
            item.setUnseenCount(response[i].unseen);
        }
    }

    private void flattenFolderTree(Vector folders, FolderTreeItem node) {
        if (node.getPath().length() > 0) {
            folders.addElement(node);
        }
        if (node.hasChildren()) {
            FolderTreeItem[] children = node.children();
            for (int i = 0; i < children.length; ++i) {
                this.flattenFolderTree(folders, children[i]);
            }
        }
    }

    public FolderTreeItem getActiveFolder() {
        return this.activeMailbox;
    }

    public void setActiveFolder(FolderTreeItem mailbox) throws IOException, MailException {
        this.activeMailbox = mailbox;
        ImapProtocol.SelectResponse response = this.imapProtocol.executeSelect(this.activeMailbox.getPath());
        this.activeMailbox.setMsgCount(response.exists);
    }

    public FolderMessage[] getFolderMessages(int firstIndex, int lastIndex) throws IOException, MailException {
        if (firstIndex > lastIndex) {
            return new FolderMessage[0];
        }
        ImapProtocol.FetchEnvelopeResponse[] response = this.imapProtocol.executeFetchEnvelope(firstIndex, lastIndex);
        FolderMessage[] folderMessages = new FolderMessage[response.length];
        for (int i = 0; i < response.length; ++i) {
            folderMessages[i] = new FolderMessage(response[i].envelope, response[i].index);
            folderMessages[i].setSeen(response[i].flags.seen);
            folderMessages[i].setAnswered(response[i].flags.answered);
            folderMessages[i].setDeleted(response[i].flags.deleted);
            folderMessages[i].setRecent(response[i].flags.recent);
            folderMessages[i].setFlagged(response[i].flags.flagged);
            folderMessages[i].setDraft(response[i].flags.draft);
        }
        return folderMessages;
    }

    public Message getMessage(FolderMessage folderMessage) throws IOException, MailException {
        ImapParser.MessageSection structure = this.getMessageStructure(folderMessage.getIndex());
        MessagePart rootPart = this.getMessagePart(folderMessage.getIndex(), structure, this.globalConfig.getImapMaxMsgSize());
        Message msg = new Message(folderMessage.getEnvelope(), rootPart);
        return msg;
    }

    private MessagePart getMessagePart(int index, ImapParser.MessageSection structure, int maxSize) throws IOException, MailException {
        MessagePart part;
        if (MessagePartFactory.isMessagePartSupported(structure.type, structure.subtype)) {
            String data;
            if (structure.type.equalsIgnoreCase("multipart")) {
                data = null;
            } else if (structure.size < maxSize) {
                data = this.getMessageBody(index, structure.address);
                maxSize -= structure.size;
            } else {
                return null;
            }
            part = MessagePartFactory.createMessagePart(structure.type, structure.subtype, structure.encoding, structure.charset, data);
        } else {
            part = null;
        }
        if (part instanceof MultiPart && structure.subsections != null && structure.subsections.length > 0) {
            for (int i = 0; i < structure.subsections.length; ++i) {
                MessagePart subPart = this.getMessagePart(index, structure.subsections[i], maxSize);
                if (subPart == null) continue;
                ((MultiPart)part).addPart(subPart);
            }
        }
        return part;
    }

    private ImapParser.MessageSection getMessageStructure(int msgIndex) throws IOException, MailException {
        if (this.activeMailbox.equals("")) {
            throw new MailException("Mailbox not selected");
        }
        return this.imapProtocol.executeFetchBodystructure(msgIndex);
    }

    private FolderTreeItem getFolderItem(FolderTreeItem parent, String folderPath) throws IOException, MailException {
        int pos = 0;
        int i = 0;
        while ((i = folderPath.indexOf(this.folderDelim, i)) != -1) {
            if (i == -1) continue;
            pos = i + 1;
            ++i;
        }
        FolderTreeItem item = new FolderTreeItem(parent, folderPath.substring(pos), folderPath, this.folderDelim);
        item.setMsgCount(0);
        return item;
    }

    private String getMessageBody(int index, String address) throws IOException, MailException {
        if (this.activeMailbox.equals("")) {
            throw new MailException("Mailbox not selected");
        }
        return this.imapProtocol.executeFetchBody(index, address);
    }
}

