/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.util.Calendar;
import java.util.Vector;
import org.logicprobe.LogicMail.mail.imap.ImapProtocol;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.util.StringParser;

class ImapParser {
    private static String strNIL = "NIL";

    private ImapParser() {
    }

    static ImapProtocol.MessageFlags parseMessageFlags(Vector flagsVec) {
        ImapProtocol.MessageFlags flags = new ImapProtocol.MessageFlags();
        int size = flagsVec.size();
        for (int i = 0; i < size; ++i) {
            if (!(flagsVec.elementAt(i) instanceof String)) continue;
            String text = (String)flagsVec.elementAt(i);
            if (text.equalsIgnoreCase("\\Seen")) {
                flags.seen = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Answered")) {
                flags.answered = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Flagged")) {
                flags.flagged = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Deleted")) {
                flags.deleted = true;
                continue;
            }
            if (text.equalsIgnoreCase("\\Draft")) {
                flags.draft = true;
                continue;
            }
            if (!text.equalsIgnoreCase("\\Recent")) continue;
            flags.recent = true;
        }
        return flags;
    }

    static MessageEnvelope parseMessageEnvelope(Vector parsedEnv) {
        if (parsedEnv.size() < 10) {
            return ImapParser.generateDummyEnvelope();
        }
        MessageEnvelope env = new MessageEnvelope();
        if (parsedEnv.elementAt(0) instanceof String) {
            env.date = StringParser.parseDateString((String)parsedEnv.elementAt(0));
        }
        if (parsedEnv.elementAt(1) instanceof String) {
            env.subject = (String)parsedEnv.elementAt(1);
        }
        if (parsedEnv.elementAt(2) instanceof Vector) {
            env.from = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(2));
        }
        if (parsedEnv.elementAt(3) instanceof Vector) {
            env.sender = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(3));
        }
        if (parsedEnv.elementAt(4) instanceof Vector) {
            env.replyTo = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(4));
        }
        if (parsedEnv.elementAt(5) instanceof Vector) {
            env.to = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(5));
        }
        if (parsedEnv.elementAt(6) instanceof Vector) {
            env.cc = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(6));
        }
        if (parsedEnv.elementAt(7) instanceof Vector) {
            env.bcc = ImapParser.parseAddressList((Vector)parsedEnv.elementAt(7));
        }
        if (parsedEnv.elementAt(8) instanceof String) {
            env.inReplyTo = (String)parsedEnv.elementAt(8);
            if (env.inReplyTo.equals(strNIL)) {
                env.inReplyTo = "";
            }
        }
        if (parsedEnv.elementAt(9) instanceof String) {
            env.messageId = (String)parsedEnv.elementAt(9);
            if (env.messageId.equals(strNIL)) {
                env.messageId = "";
            }
        }
        return env;
    }

    static String[] parseAddressList(Vector addrVec) {
        String[] addrList = new String[addrVec.size()];
        int index = 0;
        for (int i = 0; i < addrVec.size(); ++i) {
            if (!(addrVec.elementAt(i) instanceof Vector) || ((Vector)addrVec.elementAt(i)).size() < 4) continue;
            Vector entry = (Vector)addrVec.elementAt(i);
            String realName = strNIL;
            if (entry.elementAt(0) instanceof String) {
                realName = (String)entry.elementAt(0);
            }
            String mbName = strNIL;
            if (entry.elementAt(2) instanceof String) {
                mbName = (String)entry.elementAt(2);
            }
            String hostName = strNIL;
            if (entry.elementAt(3) instanceof String) {
                hostName = (String)entry.elementAt(3);
            }
            addrList[index] = realName.length() > 0 && !realName.equals(strNIL) ? realName + " <" + mbName + "@" + hostName + ">" : mbName + "@" + hostName;
            ++index;
        }
        return addrList;
    }

    static MessageEnvelope generateDummyEnvelope() {
        MessageEnvelope env = new MessageEnvelope();
        env.date = Calendar.getInstance().getTime();
        env.from = new String[1];
        env.from[0] = "<sender>";
        env.subject = "<subject>";
        return env;
    }

    static MessageSection parseMessageStructure(String rawText) {
        Vector parsedText = null;
        try {
            parsedText = StringParser.nestedParenStringLexer(rawText.substring(rawText.indexOf(40)));
        }
        catch (Exception exp) {
            return null;
        }
        if (parsedText.size() < 2 || !(parsedText.elementAt(1) instanceof Vector)) {
            return null;
        }
        Vector parsedStruct = (Vector)parsedText.elementAt(1);
        MessageSection msgStructure = ImapParser.parseMessageStructureHelper(null, 1, parsedStruct);
        ImapParser.fixMessageStructure(msgStructure);
        return msgStructure;
    }

    private static void fixMessageStructure(MessageSection msgStructure) {
        if (msgStructure == null) {
            return;
        }
        int p = msgStructure.address.indexOf(46);
        if (p != -1 && p + 1 < msgStructure.address.length()) {
            msgStructure.address = msgStructure.address.substring(p + 1);
        }
        if (msgStructure.subsections != null && msgStructure.subsections.length > 0) {
            for (int i = 0; i < msgStructure.subsections.length; ++i) {
                ImapParser.fixMessageStructure(msgStructure.subsections[i]);
            }
        }
    }

    private static MessageSection parseMessageStructureHelper(String parentAddress, int index, Vector parsedStruct) {
        String address = parentAddress == null ? Integer.toString(index) : parentAddress + "." + Integer.toString(index);
        if (parsedStruct.elementAt(0) instanceof String) {
            MessageSection section = ImapParser.parseMessageStructureSection(parsedStruct);
            section.address = address;
            return section;
        }
        if (parsedStruct.elementAt(0) instanceof Vector) {
            int size = parsedStruct.size();
            MessageSection[] subSections = new MessageSection[size - 4];
            for (int i = 0; i < size; ++i) {
                if (parsedStruct.elementAt(i) instanceof Vector) {
                    subSections[i] = ImapParser.parseMessageStructureHelper(address, i + 1, (Vector)parsedStruct.elementAt(i));
                    continue;
                }
                if (!(parsedStruct.elementAt(i) instanceof String)) continue;
                MessageSection section = new MessageSection();
                section.type = "multipart";
                section.subtype = ((String)parsedStruct.elementAt(i)).toLowerCase();
                section.subsections = subSections;
                section.address = address;
                return section;
            }
        }
        return null;
    }

    private static MessageSection parseMessageStructureSection(Vector sectionList) {
        Vector tmpVec;
        MessageSection sec = new MessageSection();
        if (sectionList.elementAt(0) instanceof String) {
            sec.type = ((String)sectionList.elementAt(0)).toLowerCase();
        }
        if (sectionList.elementAt(1) instanceof String) {
            sec.subtype = ((String)sectionList.elementAt(1)).toLowerCase();
        }
        sec.charset = null;
        if (sectionList.elementAt(2) instanceof Vector && (tmpVec = (Vector)sectionList.elementAt(2)).size() >= 2 && tmpVec.elementAt(0) instanceof String && ((String)tmpVec.elementAt(0)).equalsIgnoreCase("charset") && tmpVec.elementAt(1) instanceof String) {
            sec.charset = (String)tmpVec.elementAt(1);
        }
        if (sectionList.elementAt(5) instanceof String) {
            sec.encoding = ((String)sectionList.elementAt(5)).toLowerCase();
        }
        if (sectionList.elementAt(6) instanceof String) {
            try {
                sec.size = Integer.parseInt((String)sectionList.elementAt(6));
            }
            catch (Exception exp) {
                sec.size = -1;
            }
        }
        return sec;
    }

    public static class MessageSection {
        public String address;
        public String type;
        public String subtype;
        public String encoding;
        public String charset;
        public int size;
        public MessageSection[] subsections;
    }
}

