/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.imap.ImapParser;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.StringParser;

public class ImapProtocol {
    private Connection connection;
    private int commandCount = 0;

    public ImapProtocol(Connection connection) {
        this.connection = connection;
    }

    public boolean executeLogin(String username, String password) throws IOException, MailException {
        try {
            this.execute("LOGIN", "\"" + username + "\" \"" + password + "\"");
        }
        catch (MailException exp) {
            return false;
        }
        return true;
    }

    public void executeLogout() throws IOException, MailException {
        this.execute("LOGOUT", null);
    }

    public void executeClose() throws IOException, MailException {
        this.execute("CLOSE", null);
    }

    public Hashtable executeCapability() throws IOException, MailException {
        String[] replyText = this.execute("CAPABILITY", null);
        if (replyText == null || replyText.length < 1) {
            throw new MailException("Unable to query server capabilities");
        }
        Hashtable<String, Boolean> table = new Hashtable<String, Boolean>();
        String[] tokens = StringParser.parseTokenString(replyText[0], " ");
        if (tokens.length > 2 && tokens[1].equals("CAPABILITY")) {
            for (int i = 2; i < tokens.length; ++i) {
                table.put(tokens[i], Boolean.TRUE);
            }
        }
        return table;
    }

    public NamespaceResponse executeNamespace() throws IOException, MailException {
        Vector temp;
        int i;
        int size;
        Vector nsTokens;
        String[] replyText = this.execute("NAMESPACE", null);
        if (replyText == null || replyText.length < 1) {
            throw new MailException("Unable to query server namespaces");
        }
        Vector tokens = StringParser.nestedParenStringLexer("(" + replyText[0].substring(replyText[0].indexOf(40)) + ")");
        if (tokens == null || tokens.size() < 3) {
            return new NamespaceResponse();
        }
        NamespaceResponse response = new NamespaceResponse();
        if (tokens.elementAt(0) instanceof Vector) {
            nsTokens = (Vector)tokens.elementAt(0);
            size = nsTokens.size();
            response.personal = new Namespace[size];
            for (i = 0; i < nsTokens.size(); ++i) {
                if (!(nsTokens.elementAt(i) instanceof Vector)) continue;
                temp = (Vector)nsTokens.elementAt(i);
                response.personal[i] = new Namespace();
                if (temp.size() < 2) continue;
                if (temp.elementAt(0) instanceof String) {
                    response.personal[i].prefix = (String)temp.elementAt(0);
                }
                if (!(temp.elementAt(1) instanceof String)) continue;
                response.personal[i].delimiter = (String)temp.elementAt(1);
            }
        }
        if (tokens.elementAt(1) instanceof Vector) {
            nsTokens = (Vector)tokens.elementAt(1);
            size = nsTokens.size();
            response.other = new Namespace[size];
            for (i = 0; i < nsTokens.size(); ++i) {
                if (!(nsTokens.elementAt(i) instanceof Vector)) continue;
                temp = (Vector)nsTokens.elementAt(i);
                response.other[i] = new Namespace();
                if (temp.size() < 2) continue;
                if (temp.elementAt(0) instanceof String) {
                    response.other[i].prefix = (String)temp.elementAt(0);
                }
                if (!(temp.elementAt(1) instanceof String)) continue;
                response.other[i].delimiter = (String)temp.elementAt(1);
            }
        }
        if (tokens.elementAt(2) instanceof Vector) {
            nsTokens = (Vector)tokens.elementAt(2);
            size = nsTokens.size();
            response.shared = new Namespace[size];
            for (i = 0; i < nsTokens.size(); ++i) {
                if (!(nsTokens.elementAt(i) instanceof Vector)) continue;
                temp = (Vector)nsTokens.elementAt(i);
                response.shared[i] = new Namespace();
                if (temp.size() < 2) continue;
                if (temp.elementAt(0) instanceof String) {
                    response.shared[i].prefix = (String)temp.elementAt(0);
                }
                if (!(temp.elementAt(1) instanceof String)) continue;
                response.shared[i].delimiter = (String)temp.elementAt(1);
            }
        }
        return response;
    }

    public SelectResponse executeSelect(String mboxpath) throws IOException, MailException {
        String[] replyText = this.execute("SELECT", "\"" + mboxpath + "\"");
        SelectResponse response = new SelectResponse();
        for (int i = 0; i < replyText.length; ++i) {
            int q;
            String rowText = replyText[i];
            int p = rowText.indexOf(" EXISTS");
            if (p != -1) {
                q = p;
                p = rowText.indexOf(32);
                if (q == -1 || p == -1 || q <= p) continue;
                try {
                    response.exists = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.exists = 0;
                }
                continue;
            }
            p = rowText.indexOf(" RECENT");
            if (p != -1) {
                q = p;
                p = rowText.indexOf(32);
                if (q == -1 || p == -1 || q <= p) continue;
                try {
                    response.recent = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.recent = 0;
                }
                continue;
            }
            p = rowText.indexOf("UNSEEN ");
            if (p != -1) {
                q = rowText.indexOf(93);
                if (q == -1 || (p += 6) == -1 || q <= p) continue;
                try {
                    response.unseen = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.unseen = 0;
                }
                continue;
            }
            p = rowText.indexOf("UIDVALIDITY ");
            if (p != -1) {
                q = rowText.indexOf(93);
                if (q == -1 || (p += 11) == -1 || q <= p) continue;
                try {
                    response.uidValidity = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.uidValidity = 0;
                }
                continue;
            }
            p = rowText.indexOf("UIDNEXT ");
            if (p == -1 || (q = rowText.indexOf(93)) == -1 || (p += 7) == -1 || q <= p) continue;
            try {
                response.uidNext = Integer.parseInt(rowText.substring(p + 1, q));
                continue;
            }
            catch (NumberFormatException e) {
                response.uidNext = 0;
            }
        }
        return response;
    }

    public StatusResponse[] executeStatus(String[] mboxpaths) throws IOException, MailException {
        int i;
        StatusResponse[] response = new StatusResponse[mboxpaths.length];
        String[] arguments = new String[mboxpaths.length];
        for (i = 0; i < mboxpaths.length; ++i) {
            arguments[i] = "\"" + mboxpaths[i] + "\" (MESSAGES UNSEEN)";
        }
        String[] result = this.executeBatch("STATUS", arguments);
        if (result == null || result.length != arguments.length) {
            throw new MailException("Unable to query folder status");
        }
        for (i = 0; i < arguments.length; ++i) {
            String[] fields;
            response[i] = new StatusResponse();
            if (result[i] == null) continue;
            int p = result[i].indexOf(40);
            int q = result[i].indexOf(41);
            if (p == -1 || q == -1 || p >= q || (fields = StringParser.parseTokenString(result[i].substring(p + 1, q), " ")).length != 4) continue;
            for (int j = 0; j < fields.length; j += 2) {
                if (fields[j].equalsIgnoreCase("MESSAGES")) {
                    try {
                        response[i].exists = Integer.parseInt(fields[j + 1]);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!fields[j].equalsIgnoreCase("UNSEEN")) continue;
                try {
                    response[i].unseen = Integer.parseInt(fields[j + 1]);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return response;
    }

    public FetchEnvelopeResponse[] executeFetchEnvelope(int firstIndex, int lastIndex) throws IOException, MailException {
        String[] rawList = this.execute("FETCH", Integer.toString(firstIndex) + ":" + Integer.toString(lastIndex) + " (FLAGS ENVELOPE)");
        FetchEnvelopeResponse[] envResponses = new FetchEnvelopeResponse[lastIndex - firstIndex + 1];
        StringBuffer lineBuf = new StringBuffer();
        Vector<String> rawList2 = new Vector<String>();
        for (int i = 0; i < rawList.length; ++i) {
            String line = rawList[i];
            if (line.length() > 0 && lineBuf.toString().startsWith("* ") && line.startsWith("* ")) {
                rawList2.addElement(lineBuf.toString());
                lineBuf = new StringBuffer();
            }
            lineBuf.append(line);
            if (i != rawList.length - 1 || !lineBuf.toString().startsWith("* ")) continue;
            rawList2.addElement(lineBuf.toString());
        }
        int index = 0;
        int size = rawList2.size();
        for (int i = 0; i < size; ++i) {
            try {
                int midx;
                String rawText = (String)rawList2.elementAt(i);
                MessageEnvelope env = null;
                Vector parsedText = null;
                try {
                    parsedText = StringParser.nestedParenStringLexer(rawText.substring(rawText.indexOf(40)));
                }
                catch (Exception exp) {
                    parsedText = null;
                }
                FetchEnvelopeResponse envRespItem = new FetchEnvelopeResponse();
                envRespItem.flags = null;
                int parsedSize = parsedText.size();
                for (int j = 0; j < parsedSize; ++j) {
                    if (!(parsedText.elementAt(j) instanceof String)) continue;
                    if (((String)parsedText.elementAt(j)).equals("FLAGS") && parsedSize > j + 1 && parsedText.elementAt(j + 1) instanceof Vector) {
                        envRespItem.flags = ImapParser.parseMessageFlags((Vector)parsedText.elementAt(j + 1));
                        continue;
                    }
                    if (!((String)parsedText.elementAt(j)).equals("ENVELOPE") || parsedSize <= j + 1 || !(parsedText.elementAt(j + 1) instanceof Vector)) continue;
                    env = ImapParser.parseMessageEnvelope((Vector)parsedText.elementAt(j + 1));
                }
                if (env == null) {
                    env = ImapParser.generateDummyEnvelope();
                }
                if (envRespItem.flags == null) {
                    envRespItem.flags = new MessageFlags();
                }
                envRespItem.index = midx = Integer.parseInt(rawText.substring(rawText.indexOf(32), rawText.indexOf("FETCH") - 1).trim());
                envRespItem.envelope = env;
                envResponses[index++] = envRespItem;
                continue;
            }
            catch (Exception exp) {
                System.err.println("Parse error: " + exp);
            }
        }
        return envResponses;
    }

    public ImapParser.MessageSection executeFetchBodystructure(int index) throws IOException, MailException {
        String[] rawList = this.execute("FETCH", index + " (BODYSTRUCTURE)");
        StringBuffer lineBuf = new StringBuffer();
        Vector<String> rawList2 = new Vector<String>();
        for (int i = 0; i < rawList.length; ++i) {
            String line = rawList[i];
            if (line.length() > 0 && lineBuf.toString().startsWith("* ") && line.startsWith("* ")) {
                rawList2.addElement(lineBuf.toString());
                lineBuf = new StringBuffer();
            }
            lineBuf.append(line);
            if (i != rawList.length - 1 || !lineBuf.toString().startsWith("* ")) continue;
            rawList2.addElement(lineBuf.toString());
        }
        ImapParser.MessageSection msgStructure = null;
        int size = rawList2.size();
        for (int i = 0; i < size; ++i) {
            try {
                msgStructure = ImapParser.parseMessageStructure((String)rawList2.elementAt(i));
                continue;
            }
            catch (Exception exp) {
                System.out.println("Parse error: " + exp);
            }
        }
        return msgStructure;
    }

    public String executeFetchBody(int index, String address) throws IOException, MailException {
        String[] rawList = this.execute("FETCH", index + " (BODY[" + address + "])");
        if (rawList.length <= 1) {
            return "";
        }
        StringBuffer msgBuf = new StringBuffer();
        for (int i = 1; i < rawList.length - 1; ++i) {
            msgBuf.append(rawList[i] + "\n");
        }
        String lastLine = rawList[rawList.length - 1];
        msgBuf.append(lastLine.substring(0, lastLine.lastIndexOf(41)));
        return msgBuf.toString();
    }

    public Vector executeList(String refName, String mboxName) throws IOException, MailException {
        String[] results = this.execute("LIST", "\"" + refName + "\" \"" + mboxName + "\"");
        Vector<ListResponse> retVec = new Vector<ListResponse>(results.length);
        for (int i = 0; i < results.length; ++i) {
            String flagStr = null;
            String argStr = null;
            String temp = results[i];
            int p = temp.indexOf(40);
            int q = temp.indexOf(41, p + 1);
            if (p != -1 && q > p) {
                flagStr = temp.substring(p + 1, q);
            }
            if (temp.length() > q + 2) {
                argStr = temp.substring(q + 2);
            }
            ListResponse response = new ListResponse();
            response.delim = "";
            response.name = "";
            response.canSelect = flagStr.indexOf("\\Noselect") == -1;
            response.hasChildren = flagStr.indexOf("\\HasChildren") != -1;
            response.marked = flagStr.indexOf("\\Marked") != -1;
            p = argStr.indexOf(34);
            q = argStr.indexOf(34, p + 1);
            if (p != -1 && q > p) {
                response.delim = argStr.substring(p + 1, q);
            }
            if (argStr.length() > q + 2) {
                response.name = argStr.substring(q + 2);
                p = response.name.indexOf(34);
                q = response.name.indexOf(34, p + 1);
                if (p != -1 && q > p) {
                    response.name = response.name.substring(p + 1, q);
                }
            }
            retVec.addElement(response);
        }
        return retVec;
    }

    protected String[] executeBatch(String command, String[] arguments) throws IOException, MailException {
        String[] result = new String[arguments.length];
        int count = 0;
        Hashtable<String, Integer> commandMap = new Hashtable<String, Integer>();
        StringBuffer commandBuf = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            String tag = "A" + this.commandCount++;
            commandMap.put(tag, new Integer(i));
            commandBuf.append(tag);
            commandBuf.append(' ');
            commandBuf.append(command);
            commandBuf.append(arguments[i] == null ? "" : " " + arguments[i]);
            commandBuf.append("\r\n");
        }
        this.connection.sendRaw(commandBuf.toString());
        String tempResult = "";
        while (count < arguments.length) {
            String temp = this.connection.receive();
            if (temp.startsWith("BAD ") || temp.startsWith("NO ")) {
                throw new MailException(temp);
            }
            int p = temp.indexOf(" ");
            if (p != -1 && commandMap.containsKey(temp.substring(0, p))) {
                result[((Integer)commandMap.get((Object)temp.substring((int)0, (int)p))).intValue()] = tempResult;
                tempResult = "";
                ++count;
                continue;
            }
            tempResult = temp;
        }
        return result;
    }

    protected String[] execute(String command, String arguments) throws IOException, MailException {
        Object[] result = new String[]{};
        String tag = "A" + this.commandCount++ + " ";
        this.connection.sendCommand(tag + command + (arguments == null ? "" : " " + arguments));
        String temp = this.connection.receive();
        while (!temp.startsWith(tag)) {
            Arrays.add((Object[])result, (Object)temp);
            temp = this.connection.receive();
        }
        if ((temp = temp.substring(tag.length())).startsWith("BAD ") || temp.startsWith("NO ")) {
            throw new MailException(temp);
        }
        return result;
    }

    public static class ListResponse {
        public boolean hasChildren;
        public boolean canSelect;
        public boolean marked;
        public String delim;
        public String name;
    }

    public static class FetchEnvelopeResponse {
        public int index;
        public MessageFlags flags;
        public MessageEnvelope envelope;
    }

    public static class StatusResponse {
        public int exists;
        public int unseen;
    }

    public static class SelectResponse {
        public int exists;
        public int recent;
        public int unseen;
        public int uidNext;
        public int uidValidity;
    }

    public static class NamespaceResponse {
        public Namespace[] personal;
        public Namespace[] other;
        public Namespace[] shared;
    }

    public static class Namespace {
        public String prefix;
        public String delimiter;
    }

    public static class MessageFlags {
        public boolean seen;
        public boolean answered;
        public boolean flagged;
        public boolean deleted;
        public boolean draft;
        public boolean recent;
    }
}

