/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.pop;

import java.io.IOException;
import java.io.InputStream;
import net.rim.device.api.io.SharedInputStream;
import net.rim.device.api.mime.MIMEInputStream;
import net.rim.device.api.mime.MIMEParsingException;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.pop.PopParser;
import org.logicprobe.LogicMail.mail.pop.PopProtocol;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartFactory;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.StringParser;

public class PopClient
implements IncomingMailClient {
    private GlobalConfig globalConfig;
    private AccountConfig acctCfg;
    private Connection connection;
    private PopProtocol popProtocol;
    private String username;
    private String password;
    private boolean openStarted;
    private FolderTreeItem activeMailbox = null;

    public PopClient(GlobalConfig globalConfig, AccountConfig acctCfg) {
        this.acctCfg = acctCfg;
        this.globalConfig = globalConfig;
        this.connection = new Connection(acctCfg.getServerName(), acctCfg.getServerPort(), acctCfg.getServerSSL(), acctCfg.getDeviceSide());
        this.popProtocol = new PopProtocol(this.connection);
        this.username = acctCfg.getServerUser();
        this.password = acctCfg.getServerPass();
        this.activeMailbox = new FolderTreeItem("INBOX", "INBOX", "");
        this.activeMailbox.setMsgCount(0);
        this.openStarted = false;
    }

    public AccountConfig getAcctConfig() {
        return this.acctCfg;
    }

    public boolean open() throws IOException, MailException {
        if (!this.openStarted) {
            this.connection.open();
            this.connection.receive();
            this.openStarted = true;
        }
        try {
            this.popProtocol.executeUser(this.username);
            this.popProtocol.executePass(this.password);
        }
        catch (MailException exp) {
            return false;
        }
        this.openStarted = false;
        return true;
    }

    public void close() throws IOException, MailException {
        if (this.connection.isConnected()) {
            this.popProtocol.executeQuit();
        }
        this.activeMailbox = null;
        this.connection.close();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasFolders() {
        return false;
    }

    public FolderTreeItem getFolderTree() throws IOException, MailException {
        return null;
    }

    public void refreshFolderStatus(FolderTreeItem root) throws IOException, MailException {
        this.activeMailbox.setMsgCount(this.popProtocol.executeStat());
    }

    public FolderTreeItem getActiveFolder() {
        return this.activeMailbox;
    }

    public void setActiveFolder(FolderTreeItem mailbox) throws IOException, MailException {
        this.activeMailbox.setMsgCount(this.popProtocol.executeStat());
    }

    public FolderMessage[] getFolderMessages(int firstIndex, int lastIndex) throws IOException, MailException {
        FolderMessage[] folderMessages = new FolderMessage[lastIndex - firstIndex + 1];
        int index = 0;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            String[] headerText = this.popProtocol.executeTop(index + 1, 0);
            MessageEnvelope env = PopParser.parseMessageEnvelope(headerText);
            folderMessages[index++] = new FolderMessage(env, i);
        }
        return folderMessages;
    }

    public Message getMessage(FolderMessage folderMessage) throws IOException, MailException {
        int maxLines = this.globalConfig.getPopMaxLines();
        String[] message = this.popProtocol.executeTop(folderMessage.getIndex(), maxLines);
        MIMEInputStream mimeInputStream = null;
        try {
            mimeInputStream = new MIMEInputStream(StringParser.createInputStream(message));
        }
        catch (MIMEParsingException e) {
            return null;
        }
        MessagePart rootPart = this.getMessagePart(mimeInputStream);
        Message msg = new Message(folderMessage.getEnvelope(), rootPart);
        return msg;
    }

    private MessagePart getMessagePart(MIMEInputStream mimeInputStream) throws IOException {
        String mimeType = mimeInputStream.getContentType();
        String type = mimeType.substring(0, mimeType.indexOf(47));
        String subtype = mimeType.substring(mimeType.indexOf(47) + 1);
        String encoding = mimeInputStream.getHeader("Content-Transfer-Encoding");
        String charset = mimeInputStream.getContentTypeParameter("charset");
        if (mimeInputStream.isMultiPart() && type.equalsIgnoreCase("multipart")) {
            MessagePart part = MessagePartFactory.createMessagePart(type, subtype, null, null, null);
            MIMEInputStream[] mimeSubparts = mimeInputStream.getParts();
            for (int i = 0; i < mimeSubparts.length; ++i) {
                MessagePart subPart = this.getMessagePart(mimeSubparts[i]);
                if (subPart == null) continue;
                ((MultiPart)part).addPart(subPart);
            }
            return part;
        }
        if (encoding.equalsIgnoreCase("base64") && mimeInputStream.isPartComplete() != 0) {
            SharedInputStream sis = mimeInputStream.getRawMIMEInputStream();
            byte[] buffer = StringParser.readWholeStream((InputStream)sis);
            int offset = 0;
            while (offset + 3 < buffer.length && (buffer[offset] != 13 || buffer[offset + 1] != 10 || buffer[offset + 2] != 13 || buffer[offset + 3] != 10)) {
                ++offset;
            }
            int size = buffer.length - offset;
            return MessagePartFactory.createMessagePart(type, subtype, encoding, charset, new String(buffer, offset, size));
        }
        byte[] buffer = StringParser.readWholeStream((InputStream)mimeInputStream);
        return MessagePartFactory.createMessagePart(type, subtype, encoding, charset, new String(buffer));
    }
}

