/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.pop;

import java.io.IOException;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.util.Connection;

public class PopProtocol {
    private Connection connection;

    public PopProtocol(Connection connection) {
        this.connection = connection;
    }

    public void executeUser(String username) throws IOException, MailException {
        this.execute("USER " + username);
    }

    public void executePass(String password) throws IOException, MailException {
        this.execute("PASS " + password);
    }

    public void executeQuit() throws IOException, MailException {
        this.execute("QUIT");
    }

    public int executeStat() throws IOException, MailException {
        String result = this.execute("STAT");
        int p = result.indexOf(32);
        int q = result.indexOf(32, p + 1);
        try {
            return Integer.parseInt(result.substring(p + 1, q));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String[] executeTop(int index, int lines) throws IOException, MailException {
        return this.executeFollow("TOP " + index + " " + lines);
    }

    private String[] executeFollow(String command) throws IOException, MailException {
        this.execute(command);
        String buffer = this.connection.receive();
        Object[] lines = new String[]{};
        while (buffer != null && !buffer.equals(".")) {
            Arrays.add((Object[])lines, (Object)buffer);
            buffer = this.connection.receive();
        }
        return lines;
    }

    private String execute(String command) throws IOException, MailException {
        String result;
        if (command != null) {
            this.connection.sendCommand(command);
        }
        if ((result = this.connection.receive()).length() > 1 && result.charAt(0) == '-') {
            throw new MailException(result);
        }
        return result;
    }
}

