/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.smtp;

import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import org.logicprobe.LogicMail.AppInfo;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.mail.smtp.SmtpProtocol;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageMimeConverter;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.StringParser;

public class SmtpClient
implements OutgoingMailClient {
    private GlobalConfig globalConfig;
    private AccountConfig acctCfg;
    private Connection connection;
    private SmtpProtocol smtpProtocol;
    private Vector helloResult;
    private boolean isFresh;
    private boolean openStarted;
    private String username;
    private String password;
    private static String strCRLF = "\r\n";

    public SmtpClient(GlobalConfig globalConfig, AccountConfig acctCfg) {
        this.acctCfg = acctCfg;
        this.globalConfig = globalConfig;
        this.connection = new Connection(acctCfg.getSmtpServerName(), acctCfg.getSmtpServerPort(), acctCfg.getSmtpServerSSL(), acctCfg.getDeviceSide());
        this.smtpProtocol = new SmtpProtocol(this.connection);
        if (acctCfg.getSmtpUseAuth() > 0) {
            this.username = acctCfg.getSmtpUser();
            this.password = acctCfg.getSmtpPass();
        } else {
            this.username = null;
            this.password = null;
        }
        this.openStarted = false;
    }

    public boolean open() throws IOException, MailException {
        boolean result;
        if (!this.openStarted) {
            this.connection.open();
            this.connection.receive();
            String hostname = System.getProperty("microedition.hostname");
            if (hostname == null) {
                hostname = "localhost";
            }
            this.helloResult = this.smtpProtocol.executeExtendedHello(hostname);
            this.openStarted = true;
        }
        if (this.acctCfg.getSmtpUseAuth() > 0 && !(result = this.smtpProtocol.executeAuth(this.acctCfg.getSmtpUseAuth(), this.username, this.password))) {
            return false;
        }
        this.isFresh = true;
        this.openStarted = false;
        return true;
    }

    public void close() throws IOException, MailException {
        this.smtpProtocol.executeQuit();
        this.connection.close();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void sendMessage(Message message) throws IOException, MailException {
        if (!this.isFresh) {
            this.smtpProtocol.executeReset();
        }
        this.isFresh = false;
        MessageMimeConverter messageMime = new MessageMimeConverter();
        message.getBody().accept(messageMime);
        String mimeStr = messageMime.toMimeString();
        MessageEnvelope env = message.getEnvelope();
        StringBuffer buffer = new StringBuffer();
        buffer.append("From: " + SmtpClient.makeCsvString(env.from) + strCRLF);
        buffer.append("To: " + SmtpClient.makeCsvString(env.to) + strCRLF);
        if (env.cc != null && env.cc.length > 0) {
            buffer.append("Cc: " + SmtpClient.makeCsvString(env.cc) + strCRLF);
        }
        if (env.bcc != null && env.bcc.length > 0) {
            buffer.append("Bcc: " + SmtpClient.makeCsvString(env.bcc) + strCRLF);
        }
        if (env.replyTo != null && env.replyTo.length > 0) {
            buffer.append("Reply-To: " + SmtpClient.makeCsvString(env.replyTo) + strCRLF);
        }
        buffer.append("Date: " + StringParser.createDateString(Calendar.getInstance().getTime()) + strCRLF);
        buffer.append("User-Agent: " + AppInfo.getName() + "/" + AppInfo.getVersion() + strCRLF);
        buffer.append("Subject: " + env.subject + strCRLF);
        if (env.inReplyTo != null) {
            buffer.append("In-Reply-To: " + env.inReplyTo + strCRLF);
        }
        buffer.append(mimeStr);
        if (!this.smtpProtocol.executeMail(SmtpClient.stripEmail(env.from[0]))) {
            throw new MailException("Error with sender");
        }
        if (!this.smtpProtocol.executeRecipient(SmtpClient.stripEmail(env.to[0]))) {
            throw new MailException("Error with recipient");
        }
        if (!this.smtpProtocol.executeData(buffer.toString())) {
            throw new MailException("Error sending message");
        }
    }

    private static String makeCsvString(String[] input) {
        if (input == null || input.length == 0) {
            return "";
        }
        if (input.length == 1) {
            return input[0];
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length - 1; ++i) {
            buffer.append(input[i]);
            buffer.append(", ");
        }
        buffer.append(input[input.length - 1]);
        return buffer.toString();
    }

    private static String stripEmail(String input) {
        int p = input.indexOf(60);
        int q = input.indexOf(62);
        if (p == -1 || q == -1 || q <= p) {
            return input;
        }
        return input.substring(p + 1, q);
    }
}

