/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageForwardConverter;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessageReplyConverter;

public class Message {
    private MessageEnvelope envelope;
    private MessagePart body;

    public Message(MessageEnvelope envelope, MessagePart body) {
        this.envelope = envelope;
        this.body = body;
    }

    public MessageEnvelope getEnvelope() {
        return this.envelope;
    }

    public MessagePart getBody() {
        return this.body;
    }

    public Message toReplyMessage() {
        MessageReplyConverter replyConverter = new MessageReplyConverter(this.envelope);
        this.body.accept(replyConverter);
        MessagePart replyBody = replyConverter.toReplyBody();
        MessageEnvelope replyEnvelope = this.createReplyEnvelope();
        return new Message(replyEnvelope, replyBody);
    }

    private MessageEnvelope createReplyEnvelope() {
        MessageEnvelope replyEnvelope = new MessageEnvelope();
        replyEnvelope.subject = this.envelope.subject.startsWith("Re:") || this.envelope.subject.startsWith("re:") ? this.envelope.subject : "Re: " + this.envelope.subject;
        if (this.envelope.replyTo == null || this.envelope.replyTo.length == 0) {
            replyEnvelope.to = new String[this.envelope.sender.length];
            for (int i = 0; i < this.envelope.sender.length; ++i) {
                replyEnvelope.to[i] = this.envelope.sender[i];
            }
        } else {
            replyEnvelope.to = new String[this.envelope.replyTo.length];
            for (int i = 0; i < this.envelope.replyTo.length; ++i) {
                replyEnvelope.to[i] = this.envelope.replyTo[i];
            }
        }
        replyEnvelope.inReplyTo = this.envelope.messageId;
        return replyEnvelope;
    }

    public Message toReplyAllMessage(String myAddress) {
        int i;
        MessageReplyConverter replyConverter = new MessageReplyConverter(this.envelope);
        this.body.accept(replyConverter);
        MessagePart replyBody = replyConverter.toReplyBody();
        MessageEnvelope replyEnvelope = this.createReplyEnvelope();
        if (this.envelope.to != null) {
            for (i = 0; i < this.envelope.to.length; ++i) {
                if (this.envelope.to[i].toLowerCase().indexOf(myAddress) != -1) continue;
                if (replyEnvelope.to == null) {
                    replyEnvelope.to = new String[1];
                    replyEnvelope.to[0] = this.envelope.to[i];
                    continue;
                }
                Arrays.add((Object[])replyEnvelope.to, (Object)this.envelope.to[i]);
            }
        }
        if (this.envelope.cc != null) {
            for (i = 0; i < this.envelope.cc.length; ++i) {
                if (this.envelope.cc[i].toLowerCase().indexOf(myAddress) != -1) continue;
                if (replyEnvelope.cc == null) {
                    replyEnvelope.cc = new String[1];
                    replyEnvelope.cc[0] = this.envelope.cc[i];
                    continue;
                }
                Arrays.add((Object[])replyEnvelope.cc, (Object)this.envelope.cc[i]);
            }
        }
        return new Message(replyEnvelope, replyBody);
    }

    public Message toForwardMessage() {
        MessageForwardConverter forwardConverter = new MessageForwardConverter(this.envelope);
        this.body.accept(forwardConverter);
        MessagePart forwardBody = forwardConverter.toForwardBody();
        MessageEnvelope forwardEnvelope = new MessageEnvelope();
        forwardEnvelope.subject = this.envelope.subject.toLowerCase().startsWith("fwd:") ? this.envelope.subject : "Fwd: " + this.envelope.subject;
        return new Message(forwardEnvelope, forwardBody);
    }
}

