/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.IOException;
import net.rim.device.api.system.EncodedImage;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.util.StringParser;
import org.logicprobe.LogicMail.util.UtilProxy;

public class MessagePartFactory {
    public static MessagePart createMessagePart(String mimeType, String mimeSubtype, String encoding, String param, String data) {
        if (mimeType.equalsIgnoreCase("multipart")) {
            return MessagePartFactory.createMultiPart(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("text")) {
            return MessagePartFactory.createTextPart(mimeSubtype, encoding, param, data);
        }
        if (mimeType.equalsIgnoreCase("image")) {
            return MessagePartFactory.createImagePart(mimeSubtype, encoding, data);
        }
        return MessagePartFactory.createUnsupportedPart(mimeType, mimeSubtype, data);
    }

    public static boolean isMessagePartSupported(String mimeType, String mimeSubtype) {
        if (mimeType.equalsIgnoreCase("multipart")) {
            return MessagePartFactory.isMultiPartSupported(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("text")) {
            return MessagePartFactory.isTextPartSupported(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("image")) {
            return MessagePartFactory.isImagePartSupported(mimeSubtype);
        }
        return false;
    }

    private static MessagePart createMultiPart(String mimeSubtype) {
        return new MultiPart(mimeSubtype);
    }

    private static MessagePart createTextPart(String mimeSubtype, String encoding, String charset, String data) {
        if (encoding.equalsIgnoreCase("quoted-printable")) {
            data = StringParser.decodeQuotedPrintable(data);
        } else if (encoding.equalsIgnoreCase("base64")) {
            try {
                byte[] textBytes = UtilProxy.getInstance().Base64Decode(data);
                data = new String(textBytes, StringParser.parseValidCharsetString(charset));
            }
            catch (IOException exp) {
                return MessagePartFactory.createUnsupportedPart("text", mimeSubtype, data);
            }
        }
        if (mimeSubtype.equalsIgnoreCase("plain")) {
            TextPart textPart = new TextPart(mimeSubtype, data);
            textPart.setCharset(charset);
            return textPart;
        }
        return MessagePartFactory.createUnsupportedPart("text", mimeSubtype, data);
    }

    private static MessagePart createImagePart(String mimeSubtype, String encoding, String data) {
        if (encoding.equalsIgnoreCase("base64")) {
            try {
                byte[] imgBytes = UtilProxy.getInstance().Base64Decode(data);
                EncodedImage encImage = EncodedImage.createEncodedImage((byte[])imgBytes, (int)0, (int)imgBytes.length, (String)("image/" + mimeSubtype.toLowerCase()));
                return new ImagePart(mimeSubtype, encImage);
            }
            catch (Exception exp) {
                return MessagePartFactory.createUnsupportedPart("image", mimeSubtype, data);
            }
        }
        return MessagePartFactory.createUnsupportedPart("image", mimeSubtype, data);
    }

    private static MessagePart createUnsupportedPart(String mimeType, String mimeSubtype, String data) {
        UnsupportedPart part = new UnsupportedPart(mimeType, mimeSubtype);
        return part;
    }

    private static boolean isMultiPartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("mixed") || mimeSubtype.equalsIgnoreCase("related") || mimeSubtype.equalsIgnoreCase("alternative") || mimeSubtype.equalsIgnoreCase("signed");
    }

    private static boolean isTextPartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("plain");
    }

    private static boolean isImagePartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("gif") || mimeSubtype.equalsIgnoreCase("png") || mimeSubtype.equalsIgnoreCase("vnd.wap.wbmp") || mimeSubtype.equalsIgnoreCase("jpeg") || mimeSubtype.equalsIgnoreCase("jpg") || mimeSubtype.equalsIgnoreCase("pjpeg") || mimeSubtype.equalsIgnoreCase("bmp") || mimeSubtype.equalsIgnoreCase("tif");
    }
}

