/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.ListFieldCallback;
import net.rim.device.api.ui.component.Menu;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailClientFactory;
import org.logicprobe.LogicMail.ui.AcctCfgScreen;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.FolderScreen;
import org.logicprobe.LogicMail.ui.MailboxScreen;

public class AccountScreen
extends BaseScreen
implements ListFieldCallback {
    private MailSettings mailSettings;
    private ListField accountList;
    private MenuItem selectAcctItem = new MenuItem("Select account", 100, 10){

        public void run() {
            AccountScreen.this.selectAccount(AccountScreen.this.accountList.getSelectedIndex());
        }
    };
    private MenuItem editAcctItem = new MenuItem("Edit account", 110, 10){

        public void run() {
            AccountScreen.this.editAccount(AccountScreen.this.accountList.getSelectedIndex());
        }
    };
    private MenuItem addAcctItem = new MenuItem("Add account", 120, 10){

        public void run() {
            AccountScreen.this.addAccount();
        }
    };
    private MenuItem deleteAcctItem = new MenuItem("Delete account", 130, 10){

        public void run() {
            AccountScreen.this.deleteAccount(AccountScreen.this.accountList.getSelectedIndex());
        }
    };

    public AccountScreen() {
        super("Accounts");
        this.mailSettings = MailSettings.getInstance();
        this.accountList = new ListField();
        this.accountList.setEmptyString("No accounts", 0);
        this.accountList.setCallback((ListFieldCallback)this);
        for (int i = 0; i < this.mailSettings.getNumAccounts(); ++i) {
            this.accountList.insert(i);
        }
        this.add((Field)this.accountList);
    }

    protected boolean onSavePrompt() {
        return true;
    }

    protected void makeMenu(Menu menu, int instance) {
        if (this.mailSettings.getNumAccounts() > 0) {
            menu.add(this.selectAcctItem);
            menu.addSeparator();
            menu.add(this.editAcctItem);
        }
        menu.add(this.addAcctItem);
        if (this.mailSettings.getNumAccounts() > 0) {
            menu.add(this.deleteAcctItem);
        }
        super.makeMenu(menu, instance);
    }

    public void drawListRow(ListField list, Graphics g, int index, int y, int w) {
        String text = this.mailSettings.getAccountConfig(index).getAcctName();
        if (this.mailSettings.getAccountConfig(index).getServerType() == 0) {
            text = text.concat(" (POP)");
        } else if (this.mailSettings.getAccountConfig(index).getServerType() == 1) {
            text = text.concat(" (IMAP)");
        }
        g.drawText(text, 0, y, 0, w);
    }

    public int getPreferredWidth(ListField listField) {
        return Graphics.getScreenWidth();
    }

    public Object get(ListField listField, int index) {
        return this.mailSettings.getAccountConfig(index);
    }

    public int indexOfList(ListField listField, String prefix, int start) {
        return 0;
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': {
                if (this.accountList.getSelectedIndex() == -1 || this.mailSettings.getNumAccounts() <= 0) break;
                this.selectAccount(this.accountList.getSelectedIndex());
                retval = true;
            }
        }
        return retval;
    }

    private void addAccount() {
        AccountConfig acctConfig = new AccountConfig();
        AcctCfgScreen acctCfgScreen = new AcctCfgScreen(acctConfig);
        UiApplication.getUiApplication().pushModalScreen((Screen)acctCfgScreen);
        if (acctCfgScreen.acctSaved()) {
            this.mailSettings.addAccountConfig(acctConfig);
            this.mailSettings.saveSettings();
        }
        this.updateAccountList();
    }

    private void editAccount(int index) {
        if (index == -1) {
            return;
        }
        AccountConfig acctConfig = this.mailSettings.getAccountConfig(index);
        AcctCfgScreen acctCfgScreen = new AcctCfgScreen(acctConfig);
        UiApplication.getUiApplication().pushModalScreen((Screen)acctCfgScreen);
        if (acctCfgScreen.acctSaved()) {
            this.mailSettings.saveSettings();
        }
        this.updateAccountList();
    }

    private void deleteAccount(int index) {
        if (index == -1) {
            return;
        }
        int response = Dialog.ask((int)2);
        if (response == 3) {
            this.mailSettings.removeAccountConfig(index);
            this.mailSettings.saveSettings();
        }
        this.updateAccountList();
    }

    private void updateAccountList() {
        int numAcct = this.mailSettings.getNumAccounts();
        int selItem = this.accountList.getSelectedIndex();
        while (this.accountList.getSize() > 0) {
            this.accountList.delete(0);
        }
        for (int i = 0; i < numAcct; ++i) {
            this.accountList.insert(i);
        }
        if (selItem > numAcct) {
            selItem = numAcct;
        }
        this.accountList.setSelectedIndex(selItem);
    }

    private void selectAccount(int index) {
        AccountConfig acctConfig = this.mailSettings.getAccountConfig(index);
        if (acctConfig == null) {
            return;
        }
        IncomingMailClient client = MailClientFactory.createMailClient(acctConfig);
        if (client.hasFolders()) {
            UiApplication.getUiApplication().pushScreen((Screen)new FolderScreen(client));
        } else {
            UiApplication.getUiApplication().pushScreen((Screen)new MailboxScreen(client, client.getActiveFolder()));
        }
    }
}

