/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.EmailAddressEditField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.PasswordEditField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.text.TextFilter;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.ui.BaseCfgScreen;

public class AcctCfgScreen
extends BaseCfgScreen
implements FieldChangeListener {
    private BasicEditField fldAcctName;
    private BasicEditField fldServerName;
    private ObjectChoiceField fldServerType;
    private CheckboxField fldServerSSL;
    private BasicEditField fldServerPort;
    private BasicEditField fldServerUser;
    private PasswordEditField fldServerPass;
    private CheckboxField fldUseMDS;
    private ButtonField btSave;
    private BasicEditField fldSmtpServerName;
    private BasicEditField fldSmtpServerPort;
    private CheckboxField fldSmtpServerSSL;
    private EmailAddressEditField fldSmtpFromAddress;
    private ObjectChoiceField fldSmtpUseAuth;
    private BasicEditField fldSmtpUser;
    private PasswordEditField fldSmtpPass;
    private boolean acctSaved;
    private AccountConfig acctConfig;

    public AcctCfgScreen(AccountConfig acctConfig) {
        super("LogicMail - Account");
        this.acctConfig = acctConfig;
        this.acctSaved = false;
        this.fldAcctName = new BasicEditField("Account name: ", acctConfig.getAcctName());
        this.add((Field)this.fldAcctName);
        this.add((Field)new SeparatorField());
        this.add((Field)new RichTextField("Incoming server:", 0x80000000000000L));
        this.fldServerName = new BasicEditField("Server: ", acctConfig.getServerName());
        this.add((Field)this.fldServerName);
        Object[] serverTypes = new String[]{"POP", "IMAP"};
        this.fldServerType = new ObjectChoiceField("Protocol: ", serverTypes, acctConfig.getServerType());
        this.add((Field)this.fldServerType);
        this.fldServerType.setChangeListener((FieldChangeListener)this);
        this.fldServerSSL = new CheckboxField("SSL", acctConfig.getServerSSL());
        this.fldServerSSL.setChangeListener((FieldChangeListener)this);
        this.add((Field)this.fldServerSSL);
        this.fldServerPort = new BasicEditField("Port: ", Integer.toString(acctConfig.getServerPort()));
        this.fldServerPort.setFilter(TextFilter.get((int)1));
        this.add((Field)this.fldServerPort);
        this.fldServerUser = new BasicEditField("Username: ", acctConfig.getServerUser());
        this.add((Field)this.fldServerUser);
        this.fldServerPass = new PasswordEditField("Password: ", acctConfig.getServerPass());
        this.add((Field)this.fldServerPass);
        this.fldUseMDS = new CheckboxField("Use MDS proxy", !acctConfig.getDeviceSide());
        this.add((Field)this.fldUseMDS);
        this.add((Field)new SeparatorField());
        this.add((Field)new RichTextField("Outgoing server:", 0x80000000000000L));
        this.fldSmtpServerName = new BasicEditField("SMTP server: ", acctConfig.getSmtpServerName());
        this.add((Field)this.fldSmtpServerName);
        this.fldSmtpServerPort = new BasicEditField("Port: ", Integer.toString(acctConfig.getSmtpServerPort()));
        this.fldSmtpServerPort.setFilter(TextFilter.get((int)1));
        this.add((Field)this.fldSmtpServerPort);
        this.fldSmtpServerSSL = new CheckboxField("SSL", acctConfig.getSmtpServerSSL());
        this.add((Field)this.fldSmtpServerSSL);
        this.fldSmtpServerSSL.setChangeListener((FieldChangeListener)this);
        this.fldSmtpFromAddress = new EmailAddressEditField("E-Mail address: ", acctConfig.getSmtpFromAddress());
        this.add((Field)this.fldSmtpFromAddress);
        Object[] authTypes = new String[]{"NONE", "PLAIN", "LOGIN", "CRAM-MD5"};
        this.fldSmtpUseAuth = new ObjectChoiceField("Authentication: ", authTypes, acctConfig.getSmtpUseAuth());
        this.add((Field)this.fldSmtpUseAuth);
        this.fldSmtpUser = new BasicEditField("Username: ", acctConfig.getSmtpUser());
        this.add((Field)this.fldSmtpUser);
        this.fldSmtpPass = new PasswordEditField("Password: ", acctConfig.getSmtpPass());
        this.add((Field)this.fldSmtpPass);
        if (acctConfig.getSmtpUseAuth() == 0) {
            this.fldSmtpUser.setEditable(false);
            this.fldSmtpPass.setEditable(false);
            this.fldSmtpUser.setText("");
            this.fldSmtpPass.setText("");
        }
        this.fldSmtpUseAuth.setChangeListener((FieldChangeListener)this);
        this.add((Field)new LabelField(null, 0x80000000000000L));
        this.btSave = new ButtonField("Save", 0x300000000L);
        this.btSave.setChangeListener((FieldChangeListener)this);
        this.add((Field)this.btSave);
    }

    public void fieldChanged(Field field, int context) {
        if (field == this.btSave) {
            this.onClose();
        } else if (field == this.fldServerType || field == this.fldServerSSL) {
            if (this.fldServerType.getSelectedIndex() == 0) {
                if (this.fldServerSSL.getChecked()) {
                    this.fldServerPort.setText("995");
                } else {
                    this.fldServerPort.setText("110");
                }
            } else if (this.fldServerType.getSelectedIndex() == 1) {
                if (this.fldServerSSL.getChecked()) {
                    this.fldServerPort.setText("993");
                } else {
                    this.fldServerPort.setText("143");
                }
            }
        } else if (field == this.fldSmtpServerSSL) {
            if (this.fldSmtpServerSSL.getChecked()) {
                this.fldSmtpServerPort.setText("465");
            } else {
                this.fldSmtpServerPort.setText("25");
            }
        } else if (field == this.fldSmtpUseAuth) {
            if (this.fldSmtpUseAuth.getSelectedIndex() > 0) {
                this.fldSmtpUser.setEditable(true);
                this.fldSmtpPass.setEditable(true);
                this.fldSmtpUser.setText(this.acctConfig.getSmtpUser());
                this.fldSmtpPass.setText(this.acctConfig.getSmtpPass());
            } else {
                this.fldSmtpUser.setEditable(false);
                this.fldSmtpPass.setEditable(false);
                this.fldSmtpUser.setText("");
                this.fldSmtpPass.setText("");
            }
        }
    }

    public void save() {
        this.acctConfig.setAcctName(this.fldAcctName.getText());
        this.acctConfig.setServerName(this.fldServerName.getText());
        this.acctConfig.setServerType(this.fldServerType.getSelectedIndex());
        this.acctConfig.setServerSSL(this.fldServerSSL.getChecked());
        this.acctConfig.setServerPort(Integer.parseInt(this.fldServerPort.getText()));
        this.acctConfig.setServerUser(this.fldServerUser.getText());
        this.acctConfig.setServerPass(this.fldServerPass.getText());
        this.acctConfig.setDeviceSide(!this.fldUseMDS.getChecked());
        this.acctConfig.setSmtpServerName(this.fldSmtpServerName.getText());
        this.acctConfig.setSmtpServerPort(Integer.parseInt(this.fldSmtpServerPort.getText()));
        this.acctConfig.setSmtpServerSSL(this.fldSmtpServerSSL.getChecked());
        this.acctConfig.setSmtpFromAddress(this.fldSmtpFromAddress.getText());
        this.acctConfig.setSmtpUseAuth(this.fldSmtpUseAuth.getSelectedIndex());
        if (this.fldSmtpUseAuth.getSelectedIndex() > 0) {
            this.acctConfig.setSmtpUser(this.fldSmtpUser.getText());
            this.acctConfig.setSmtpPass(this.fldSmtpPass.getText());
        }
        this.acctSaved = true;
    }

    public boolean acctSaved() {
        return this.acctSaved;
    }
}

