/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.EditField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.mail.MailClientFactory;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartFactory;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.EmailAddressBookEditField;
import org.logicprobe.LogicMail.ui.MailClientHandler;
import org.logicprobe.LogicMail.ui.MailClientHandlerListener;

public class CompositionScreen
extends BaseScreen
implements MailClientHandlerListener {
    private AccountConfig acctConfig;
    private OutgoingMailClient client;
    private VerticalFieldManager vfmRecipients;
    private EditField fldSubject;
    private EditField fldEdit;
    private String inReplyTo;
    private MenuItem sendMenuItem = new MenuItem("Send", 200000, 10){

        public void run() {
            CompositionScreen.this.sendMessage();
        }
    };
    private MenuItem addToMenuItem = new MenuItem("Add To:", 200110, 10){

        public void run() {
            CompositionScreen.this.insertRecipientField(EmailAddressBookEditField.ADDRESS_TO);
        }
    };
    private MenuItem addCcMenuItem = new MenuItem("Add Cc:", 200120, 10){

        public void run() {
            CompositionScreen.this.insertRecipientField(EmailAddressBookEditField.ADDRESS_CC);
        }
    };
    private MenuItem addBccMenuItem = new MenuItem("Add Bcc:", 200130, 10){

        public void run() {
            CompositionScreen.this.insertRecipientField(EmailAddressBookEditField.ADDRESS_BCC);
        }
    };

    public CompositionScreen(AccountConfig acctConfig) {
        this.acctConfig = acctConfig;
        this.client = MailClientFactory.createOutgoingMailClient(acctConfig);
        this.vfmRecipients = new VerticalFieldManager();
        this.vfmRecipients.add((Field)new EmailAddressBookEditField(EmailAddressBookEditField.ADDRESS_TO, ""));
        this.vfmRecipients.add((Field)new EmailAddressBookEditField(EmailAddressBookEditField.ADDRESS_CC, ""));
        this.add((Field)this.vfmRecipients);
        this.fldSubject = new EditField("Subject: ", "");
        this.add((Field)this.fldSubject);
        this.add((Field)new SeparatorField());
        this.fldEdit = new EditField();
        String sig = MailSettings.getInstance().getGlobalConfig().getMsgSignature();
        if (sig != null && sig.length() > 0) {
            this.fldEdit.insert("\r\n--\r\n" + sig);
            this.fldEdit.setCursorPosition(0);
        }
        this.add((Field)this.fldEdit);
    }

    public CompositionScreen(AccountConfig acctConfig, Message message) {
        this(acctConfig);
        int i;
        MessagePart body = message.getBody();
        MessageEnvelope env = message.getEnvelope();
        if (body instanceof TextPart) {
            this.fldEdit.insert("\r\n");
            this.fldEdit.insert(((TextPart)body).getText());
            this.fldEdit.setCursorPosition(0);
        }
        this.fldSubject.setText(env.subject);
        if (env.to != null) {
            for (i = 0; i < env.to.length; ++i) {
                this.insertRecipientField(EmailAddressBookEditField.ADDRESS_TO).setAddress(env.to[i]);
            }
        }
        if (env.cc != null) {
            for (i = 0; i < env.cc.length; ++i) {
                this.insertRecipientField(EmailAddressBookEditField.ADDRESS_CC).setAddress(env.cc[i]);
            }
        }
        if (env.bcc != null) {
            for (i = 0; i < env.bcc.length; ++i) {
                this.insertRecipientField(EmailAddressBookEditField.ADDRESS_BCC).setAddress(env.bcc[i]);
            }
        }
        this.inReplyTo = env.inReplyTo;
    }

    protected void makeMenu(Menu menu, int instance) {
        if (((EmailAddressBookEditField)this.vfmRecipients.getField(0)).getText().length() > 0) {
            menu.add(this.sendMenuItem);
            menu.addSeparator();
        }
        menu.add(this.addToMenuItem);
        menu.add(this.addCcMenuItem);
        menu.add(this.addBccMenuItem);
        menu.addSeparator();
    }

    private void sendMessage() {
        MessageEnvelope env = new MessageEnvelope();
        env.inReplyTo = this.inReplyTo;
        int size = this.vfmRecipients.getFieldCount();
        for (int i = 0; i < size; ++i) {
            EmailAddressBookEditField currentField = (EmailAddressBookEditField)this.vfmRecipients.getField(i);
            if (currentField.getAddressType() == EmailAddressBookEditField.ADDRESS_TO && currentField.getText().length() > 0) {
                if (env.to == null) {
                    env.to = new String[1];
                    env.to[0] = currentField.getText();
                    continue;
                }
                Arrays.add((Object[])env.to, (Object)currentField.getText());
                continue;
            }
            if (currentField.getAddressType() == EmailAddressBookEditField.ADDRESS_CC && currentField.getText().length() > 0) {
                if (env.cc == null) {
                    env.cc = new String[1];
                    env.cc[0] = currentField.getText();
                    continue;
                }
                Arrays.add((Object[])env.cc, (Object)currentField.getText());
                continue;
            }
            if (currentField.getAddressType() != EmailAddressBookEditField.ADDRESS_BCC || currentField.getText().length() <= 0) continue;
            if (env.bcc == null) {
                env.bcc = new String[1];
                env.bcc[0] = currentField.getText();
                continue;
            }
            Arrays.add((Object[])env.bcc, (Object)currentField.getText());
        }
        env.from = new String[1];
        String fromAddress = this.acctConfig.getSmtpFromAddress();
        if (fromAddress == null || fromAddress.length() == 0) {
            fromAddress = this.acctConfig.getServerUser() + "@" + this.acctConfig.getServerName();
        }
        env.from[0] = MailSettings.getInstance().getGlobalConfig().getFullname() + " <" + fromAddress + ">";
        env.subject = this.fldSubject.getText();
        MessagePart bodyPart = MessagePartFactory.createMessagePart("text", "plain", "7bit", "us-ascii", this.fldEdit.getText());
        Message message = new Message(env, bodyPart);
        SendMessageHandler sendHandler = new SendMessageHandler(message);
        sendHandler.setListener(this);
        sendHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mailActionComplete(MailClientHandler source, boolean result) {
        if (result) {
            Object object = Application.getEventLock();
            synchronized (object) {
                this.close();
            }
        }
    }

    private EmailAddressBookEditField insertRecipientField(int addressType) {
        EmailAddressBookEditField currentField;
        int i;
        int size = this.vfmRecipients.getFieldCount();
        for (i = 0; i < size; ++i) {
            currentField = (EmailAddressBookEditField)this.vfmRecipients.getField(i);
            if (currentField.getAddressType() != addressType || currentField.getText().length() != 0) continue;
            currentField.setFocus();
            return currentField;
        }
        if (addressType == EmailAddressBookEditField.ADDRESS_TO) {
            for (i = 0; i < size; ++i) {
                currentField = (EmailAddressBookEditField)this.vfmRecipients.getField(i);
                if (currentField.getAddressType() == EmailAddressBookEditField.ADDRESS_TO) continue;
                currentField = new EmailAddressBookEditField(EmailAddressBookEditField.ADDRESS_TO, "");
                this.vfmRecipients.insert((Field)currentField, i);
                currentField.setFocus();
                return currentField;
            }
        } else if (addressType == EmailAddressBookEditField.ADDRESS_CC) {
            for (i = 0; i < size; ++i) {
                currentField = (EmailAddressBookEditField)this.vfmRecipients.getField(i);
                if (currentField.getAddressType() == EmailAddressBookEditField.ADDRESS_TO || currentField.getAddressType() == EmailAddressBookEditField.ADDRESS_CC) {
                    continue;
                }
                currentField = new EmailAddressBookEditField(EmailAddressBookEditField.ADDRESS_CC, "");
                this.vfmRecipients.insert((Field)currentField, i);
                currentField.setFocus();
                return currentField;
            }
        }
        currentField = new EmailAddressBookEditField(addressType, "");
        this.vfmRecipients.add((Field)currentField);
        currentField.setFocus();
        return currentField;
    }

    public boolean keyChar(char key, int status, int time) {
        switch (key) {
            case '\b': {
                EmailAddressBookEditField currentField = (EmailAddressBookEditField)this.vfmRecipients.getFieldWithFocus();
                if (currentField == null || this.vfmRecipients.getFieldWithFocusIndex() == 0 || currentField.getText().length() > 0) break;
                int index = currentField.getIndex();
                this.vfmRecipients.delete((Field)currentField);
                this.vfmRecipients.getField(index - 1).setFocus();
                return true;
            }
        }
        return super.keyChar(key, status, time);
    }

    private class SendMessageHandler
    extends MailClientHandler {
        private Message message;

        public SendMessageHandler(Message message) {
            super(CompositionScreen.this.client, "Sending message");
            this.message = message;
        }

        public void runSession() throws IOException, MailException {
            ((OutgoingMailClient)this.client).sendMessage(this.message);
            this.client.close();
        }
    }
}

