/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.AutoTextEditField;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.text.TextFilter;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.ui.BaseCfgScreen;

public class ConfigScreen
extends BaseCfgScreen
implements FieldChangeListener {
    private MailSettings mailSettings = MailSettings.getInstance();
    private BasicEditField fldFullname;
    private BasicEditField fldRetMsgCount;
    private ObjectChoiceField fldDispOrder;
    private BasicEditField fldImapMaxMsgSize;
    private BasicEditField fldImapMaxFolderDepth;
    private BasicEditField fldPopMaxLines;
    private AutoTextEditField fldSignature;
    private ButtonField btSave;

    public ConfigScreen() {
        super("LogicMail - Config");
        GlobalConfig config = this.mailSettings.getGlobalConfig();
        this.add((Field)new RichTextField("Global settings:", 0x80000000000000L));
        this.fldFullname = new BasicEditField("  Full name: ", config.getFullname());
        this.add((Field)this.fldFullname);
        this.fldRetMsgCount = new BasicEditField("  Message count: ", Integer.toString(config.getRetMsgCount()));
        this.fldRetMsgCount.setFilter(TextFilter.get((int)1));
        this.add((Field)this.fldRetMsgCount);
        Object[] orderTypes = new String[]{"Ascending", "Descending"};
        this.fldDispOrder = !config.getDispOrder() ? new ObjectChoiceField("  Message order: ", orderTypes, 0) : new ObjectChoiceField("  Message order: ", orderTypes, 1);
        this.add((Field)this.fldDispOrder);
        this.add((Field)new RichTextField("IMAP settings:", 0x80000000000000L));
        this.fldImapMaxMsgSize = new BasicEditField("  Max size to dl per msg (kb): ", Integer.toString(config.getImapMaxMsgSize() / 1024));
        this.fldImapMaxMsgSize.setFilter(TextFilter.get((int)1));
        this.add((Field)this.fldImapMaxMsgSize);
        this.fldImapMaxFolderDepth = new BasicEditField("  Max folder depth: ", Integer.toString(config.getImapMaxFolderDepth()));
        this.fldImapMaxFolderDepth.setFilter(TextFilter.get((int)1));
        this.add((Field)this.fldImapMaxFolderDepth);
        this.add((Field)new RichTextField("POP settings:", 0x80000000000000L));
        this.fldPopMaxLines = new BasicEditField("  Max lines to dl per msg: ", Integer.toString(config.getPopMaxLines()));
        this.fldPopMaxLines.setFilter(TextFilter.get((int)1));
        this.add((Field)this.fldPopMaxLines);
        this.add((Field)new SeparatorField());
        this.add((Field)new RichTextField("Signature:", 0x80000000000000L));
        this.fldSignature = new AutoTextEditField();
        this.add((Field)this.fldSignature);
        this.fldSignature.setText(config.getMsgSignature());
        this.add((Field)new SeparatorField());
        this.btSave = new ButtonField("Save", 0x300000000L);
        this.btSave.setChangeListener((FieldChangeListener)this);
        this.add((Field)this.btSave);
    }

    public void fieldChanged(Field field, int context) {
        if (field == this.btSave) {
            this.onClose();
        }
    }

    public void save() {
        GlobalConfig config = this.mailSettings.getGlobalConfig();
        config.setFullname(this.fldFullname.getText());
        try {
            config.setRetMsgCount(Integer.parseInt(this.fldRetMsgCount.getText()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.fldDispOrder.getSelectedIndex() == 0) {
            config.setDispOrder(false);
        } else {
            config.setDispOrder(true);
        }
        try {
            config.setImapMaxMsgSize(Integer.parseInt(this.fldImapMaxMsgSize.getText()) * 1024);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            config.setImapMaxFolderDepth(Integer.parseInt(this.fldImapMaxFolderDepth.getText()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            config.setPopMaxLines(Integer.parseInt(this.fldPopMaxLines.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.setMsgSignature(this.fldSignature.getText());
        this.mailSettings.saveSettings();
    }
}

