/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.ControlledAccessException;
import net.rim.device.api.ui.ContextMenu;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EmailAddressEditField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.util.Arrays;

public class EmailAddressBookEditField
extends EmailAddressEditField {
    private String name;
    private String address;
    private Bitmap bmapContactItem;
    private Bitmap bmapContactNonItem;
    private int addressType;
    private boolean inAddressBook;
    public static int ADDRESS_TO = 1;
    public static int ADDRESS_CC = 2;
    public static int ADDRESS_BCC = 3;
    private MenuItem addressPropertiesMenuItem = new MenuItem("Properties", 200000, 10){

        public void run() {
            EmailAddressBookEditField.this.addressProperties();
        }
    };
    private MenuItem addressBookMenuItem = new MenuItem("Address book", 200010, 10){

        public void run() {
            EmailAddressBookEditField.this.addressBookChooser();
        }
    };

    public EmailAddressBookEditField(int addressType, String initialValue) {
        super("", initialValue);
        if (addressType == ADDRESS_TO) {
            this.setLabel("To: ");
        } else if (addressType == ADDRESS_CC) {
            this.setLabel("Cc: ");
        } else if (addressType == ADDRESS_BCC) {
            this.setLabel("Bcc: ");
        } else {
            this.setLabel("To: ");
            addressType = ADDRESS_TO;
        }
        this.addressType = addressType;
        this.name = null;
        this.address = "";
        this.bmapContactItem = Bitmap.getBitmapResource((String)"contact_item.png");
        this.bmapContactNonItem = Bitmap.getBitmapResource((String)"contact_nonitem.png");
    }

    public String getText() {
        if (this.name != null) {
            return this.address;
        }
        return super.getText();
    }

    public void setAddress(String sourceAddress) {
        sourceAddress = sourceAddress.trim();
        int p = sourceAddress.indexOf(60);
        int q = sourceAddress.indexOf(62);
        this.address = p == -1 && q == -1 ? sourceAddress : (p != -1 && q != -1 && p < q && sourceAddress.length() > 2 ? sourceAddress.substring(p + 1, q) : (p != -1 && q == -1 && sourceAddress.length() > 1 ? sourceAddress.substring(p + 1) : ""));
        if (this.address.equals("")) {
            return;
        }
        this.name = p != -1 && p > 0 ? sourceAddress.substring(0, p).trim() : null;
        if (this.name != null) {
            this.setText(this.name);
            this.setEditable(false);
        } else {
            this.setText(this.address);
            this.setEditable(true);
        }
        this.inAddressBook = false;
    }

    public int getAddressType() {
        return this.addressType;
    }

    protected void makeContextMenu(ContextMenu contextMenu) {
        if (this.name != null || super.getText().length() > 0) {
            contextMenu.addItem(this.addressPropertiesMenuItem);
        }
        contextMenu.addItem(this.addressBookMenuItem);
    }

    protected void paint(Graphics graphics) {
        if (this.name != null) {
            int width = this.getExtent().width;
            int height = this.getExtent().height;
            int x = this.getExtent().x;
            int y = this.getExtent().y;
            int labelWidth = graphics.drawText(this.getLabel(), x, y, (int)this.getStyle(), width);
            int nameWidth = graphics.drawText(this.name, x + labelWidth, y, (int)(this.getStyle() | 0x40L), width - labelWidth - this.bmapContactItem.getWidth() - 5);
            if (this.inAddressBook) {
                graphics.drawBitmap(x + labelWidth + nameWidth + 5, y, width, height, this.bmapContactItem, 0, 0);
            } else {
                graphics.drawBitmap(x + labelWidth + nameWidth + 5, y, width, height, this.bmapContactNonItem, 0, 0);
            }
        } else {
            super.paint(graphics);
        }
    }

    protected boolean keyChar(char key, int status, int time) {
        switch (key) {
            case '\b': 
            case '\u007f': {
                if (this.name == null) break;
                this.name = null;
                this.address = "";
                this.setText(this.address);
                this.setEditable(true);
                this.setFocus();
                return true;
            }
        }
        return super.keyChar(key, status, time);
    }

    private void addressProperties() {
        String localAddress;
        String localName;
        if (this.name != null) {
            localName = this.name;
            localAddress = this.address != null ? this.address : "";
        } else {
            localName = "";
            localAddress = super.getText();
        }
        AddressPropertiesDialog dialog = new AddressPropertiesDialog(localName, localAddress);
        if (!(dialog.doModal() != 0 || localName.equals(dialog.getName()) && localAddress.equals(dialog.getAddress()))) {
            localName = dialog.getName();
            localAddress = dialog.getAddress();
            this.name = localName.length() > 0 ? localName : null;
            this.address = localAddress;
            if (this.name != null) {
                this.setText(this.name);
                this.setEditable(false);
            } else {
                this.setText(this.address);
                this.setEditable(true);
            }
            this.inAddressBook = false;
        }
    }

    private void addressBookChooser() {
        Vector contacts = this.getAddressList();
        Object[] names = new String[contacts.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((ContactItem)contacts.elementAt((int)i)).name;
        }
        Dialog abDlg = new Dialog("Address book", names, null, 0, null, 1L);
        int choice = abDlg.doModal();
        if (choice < 0 || choice > contacts.size()) {
            return;
        }
        ContactItem contactItem = (ContactItem)contacts.elementAt(choice);
        Object[] email = contactItem.email;
        if (email == null) {
            this.setText("");
            this.inAddressBook = false;
        } else if (email.length > 1) {
            Dialog addrDlg = new Dialog("Which address?", email, null, 0, Bitmap.getPredefinedBitmap((int)1));
            choice = addrDlg.doModal();
            this.address = email[choice];
            this.name = contactItem.name;
            this.setText(this.name);
            this.setEditable(false);
            this.inAddressBook = true;
        } else {
            this.address = email[0];
            this.name = contactItem.name;
            this.setText(this.name);
            this.setEditable(false);
            this.inAddressBook = true;
        }
    }

    private Vector getAddressList() {
        Vector<ContactItem> addressList = new Vector<ContactItem>();
        try {
            PIM pim = PIM.getInstance();
            ContactList contactList = (ContactList)pim.openPIMList(1, 1);
            Enumeration enumList = contactList.items();
            while (enumList.hasMoreElements()) {
                ContactItem contactItem = new ContactItem();
                Contact c = (Contact)enumList.nextElement();
                int[] fieldIds = c.getFields();
                for (int i = 0; i < fieldIds.length; ++i) {
                    if (fieldIds[i] == 106) {
                        String[] values = c.getStringArray(106, 0);
                        contactItem.name = values[1] + " " + values[0];
                    }
                    if (fieldIds[i] != 103) continue;
                    for (int j = 0; j < c.countValues(103); ++j) {
                        if (contactItem.email == null) {
                            contactItem.email = new String[1];
                            contactItem.email[0] = c.getString(103, j);
                            continue;
                        }
                        Arrays.add((Object[])contactItem.email, (Object)c.getString(103, j));
                    }
                }
                if (contactItem.name == null || contactItem.email == null) continue;
                addressList.addElement(contactItem);
            }
        }
        catch (ControlledAccessException e) {
        }
        catch (PIMException pIMException) {
            // empty catch block
        }
        return addressList;
    }

    private static class ContactItem {
        String name;
        String[] email;

        private ContactItem() {
        }
    }

    private static class AddressPropertiesDialog
    extends Dialog {
        private BasicEditField fldName;
        private EmailAddressEditField fldAddress;

        public AddressPropertiesDialog(String name, String address) {
            super("Address Properties", null, null, 0, Bitmap.getPredefinedBitmap((int)1), 0x40000300000000L);
            this.fldName = new BasicEditField("Name: ", name);
            try {
                this.fldAddress = new EmailAddressEditField("Address: ", address);
            }
            catch (Exception e) {
                this.fldAddress = new EmailAddressEditField("Address: ", "");
            }
            this.add((Field)this.fldName);
            this.add((Field)this.fldAddress);
            this.add((Field)new LabelField((Object)"", 0x80000000000000L));
            ButtonField btnOk = new ButtonField("OK", 0x40000300000000L);
            btnOk.setChangeListener(new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    AddressPropertiesDialog.this.select(0);
                    AddressPropertiesDialog.this.close();
                }
            });
            this.add((Field)btnOk);
        }

        public String getName() {
            return this.fldName.getText();
        }

        public String getAddress() {
            return this.fldAddress.getText();
        }
    }
}

