/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import java.util.Vector;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import org.logicprobe.LogicMail.cache.AccountCache;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.CompositionScreen;
import org.logicprobe.LogicMail.ui.MailClientHandler;
import org.logicprobe.LogicMail.ui.MailClientHandlerListener;
import org.logicprobe.LogicMail.ui.MailboxScreen;
import org.logicprobe.LogicMail.util.SerializableHashtable;

public class FolderScreen
extends BaseScreen
implements TreeFieldCallback,
MailClientHandlerListener {
    private TreeField treeField;
    private IncomingMailClient client;
    private RefreshFolderTreeHandler refreshFolderTreeHandler;
    private RefreshFolderStatusHandler refreshFolderStatusHandler;
    private AccountCache acctCache;
    private FolderTreeItem folderTreeRoot;
    private MenuItem folderItem = new MenuItem("Select", 100, 10){

        public void run() {
            FolderScreen.this.openSelectedFolder();
        }
    };
    private MenuItem refreshStatusItem = new MenuItem("Refresh status", 110, 10){

        public void run() {
            FolderScreen.this.refreshFolderStatus();
        }
    };
    private MenuItem refreshItem = new MenuItem("Refresh folders", 111, 10){

        public void run() {
            FolderScreen.this.refreshFolderTree();
        }
    };
    private MenuItem compositionItem = new MenuItem("Compose E-Mail", 120, 10){

        public void run() {
            UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(FolderScreen.this.client.getAcctConfig()));
        }
    };

    public FolderScreen(IncomingMailClient client) {
        super("Folders");
        this.client = client;
        this.treeField = new TreeField((TreeFieldCallback)this, 0x40000000000000L);
        this.treeField.setEmptyString("No folders", 0);
        this.treeField.setDefaultExpanded(true);
        this.treeField.setIndentWidth(20);
        this.add((Field)this.treeField);
        this.acctCache = new AccountCache(this.client.getAcctConfig().getAcctName());
        this.folderTreeRoot = this.acctCache.loadFolderTree();
        if (this.folderTreeRoot != null && this.folderTreeRoot.hasChildren()) {
            this.generateFolderTree(this.folderTreeRoot);
            this.loadFolderMetadata();
        } else {
            this.refreshFolderTree();
        }
    }

    protected boolean onSavePrompt() {
        return true;
    }

    public boolean onClose() {
        if (this.checkClose()) {
            this.saveFolderMetadata();
            this.close();
            return true;
        }
        return false;
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.add(this.folderItem);
        menu.add(this.refreshStatusItem);
        menu.add(this.refreshItem);
        menu.add(this.compositionItem);
        super.makeMenu(menu, instance);
    }

    public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        Object cookie = treeField.getCookie(node);
        Font origFont = graphics.getFont();
        if (cookie instanceof FolderTreeItem) {
            FolderTreeItem item = (FolderTreeItem)cookie;
            StringBuffer buf = new StringBuffer();
            buf.append(item.getName());
            if (item.getUnseenCount() > 0) {
                buf.append(" (");
                buf.append(Integer.toString(item.getUnseenCount()));
                buf.append(")");
                graphics.setFont(origFont.derive(1));
            } else {
                graphics.setFont(origFont.derive(0));
            }
            graphics.drawText(buf.toString(), indent, y, 64, width);
        }
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case ' ': {
                this.toggleSelectedFolder();
                retval = true;
                break;
            }
            case '\n': {
                this.openSelectedFolder();
                retval = true;
            }
        }
        return retval;
    }

    private boolean checkClose() {
        if (this.client.isConnected()) {
            if (Dialog.ask((int)3, (String)"Disconnect from server?") == 4) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void loadFolderMetadata() {
        SerializableHashtable folderMetadata = this.acctCache.loadAccountMetadata("ui_folder");
        if (folderMetadata != null) {
            int curNode = this.treeField.nextNode(0, 0, true);
            Vector<Object[]> actions = new Vector<Object[]>();
            while (curNode > 0) {
                Object value;
                Object cookie;
                if (this.treeField.getFirstChild(curNode) != -1 && (cookie = this.treeField.getCookie(curNode)) instanceof FolderTreeItem && (value = folderMetadata.get(((FolderTreeItem)cookie).getPath())) instanceof Boolean) {
                    actions.addElement(new Object[]{new Integer(curNode), value});
                }
                curNode = this.treeField.nextNode(curNode, 0, true);
            }
            for (int i = actions.size() - 1; i >= 0; --i) {
                Object[] action = (Object[])actions.elementAt(i);
                this.treeField.setExpanded(((Integer)action[0]).intValue(), ((Boolean)action[1]).booleanValue());
            }
        }
        this.treeField.setCurrentNode(this.treeField.getFirstChild(0));
    }

    public void saveFolderMetadata() {
        SerializableHashtable folderMetadata = new SerializableHashtable();
        int curNode = this.treeField.nextNode(0, 0, true);
        while (curNode > 0) {
            Object cookie;
            if (this.treeField.getFirstChild(curNode) != -1 && (cookie = this.treeField.getCookie(curNode)) instanceof FolderTreeItem) {
                folderMetadata.put(((FolderTreeItem)cookie).getPath(), new Boolean(this.treeField.getExpanded(curNode)));
            }
            curNode = this.treeField.nextNode(curNode, 0, true);
        }
        this.acctCache.saveAccountMetadata("ui_folder", folderMetadata);
    }

    public void refreshFolderTree() {
        if (this.refreshFolderTreeHandler == null) {
            this.refreshFolderTreeHandler = new RefreshFolderTreeHandler();
            this.refreshFolderTreeHandler.setListener(this);
        }
        this.refreshFolderTreeHandler.start();
    }

    public void refreshFolderStatus() {
        if (this.refreshFolderStatusHandler == null) {
            this.refreshFolderStatusHandler = new RefreshFolderStatusHandler(this.folderTreeRoot);
            this.refreshFolderStatusHandler.setListener(this);
        }
        this.refreshFolderStatusHandler.start();
    }

    private void openSelectedFolder() {
        if (this.treeField == null) {
            return;
        }
        int curNode = this.treeField.getCurrentNode();
        if (curNode == -1) {
            return;
        }
        Object cookie = this.treeField.getCookie(curNode);
        if (cookie instanceof FolderTreeItem) {
            UiApplication.getUiApplication().pushScreen((Screen)new MailboxScreen(this.client, (FolderTreeItem)cookie));
        }
    }

    private void toggleSelectedFolder() {
        if (this.treeField == null) {
            return;
        }
        int curNode = this.treeField.getCurrentNode();
        if (curNode == -1) {
            return;
        }
        if (this.treeField.getFirstChild(curNode) == -1) {
            return;
        }
        this.treeField.setExpanded(curNode, !this.treeField.getExpanded(curNode));
    }

    private synchronized void generateFolderTree(FolderTreeItem folderRoot) {
        this.treeField.deleteAll();
        this.generateFolderTreeHelper(this.treeField, 0, folderRoot);
        this.treeField.setDirty(true);
    }

    public void generateFolderTreeHelper(TreeField tree, int parent, FolderTreeItem item) {
        int id = item.getParent() == null ? 0 : tree.addChildNode(parent, (Object)item);
        this.treeField.invalidateNode(id);
        if (item.hasChildren()) {
            FolderTreeItem[] children = item.children();
            for (int i = children.length - 1; i >= 0; --i) {
                this.generateFolderTreeHelper(tree, id, children[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mailActionComplete(MailClientHandler source, boolean result) {
        if (source.equals(this.refreshFolderTreeHandler)) {
            if (this.refreshFolderTreeHandler.getFolderRoot() != null) {
                Object object = Application.getEventLock();
                synchronized (object) {
                    this.folderTreeRoot = this.refreshFolderTreeHandler.getFolderRoot();
                    this.generateFolderTree(this.folderTreeRoot);
                }
            }
        } else if (source.equals(this.refreshFolderStatusHandler)) {
            Object object = Application.getEventLock();
            synchronized (object) {
                if (this.folderTreeRoot != null) {
                    this.generateFolderTree(this.folderTreeRoot);
                }
            }
        }
    }

    private class RefreshFolderStatusHandler
    extends MailClientHandler {
        private FolderTreeItem folderRoot;

        public RefreshFolderStatusHandler(FolderTreeItem folderRoot) {
            super(FolderScreen.this.client, "Refreshing folder status");
            this.folderRoot = folderRoot;
        }

        public void runSession() throws IOException, MailException {
            ((IncomingMailClient)this.client).refreshFolderStatus(this.folderRoot);
        }
    }

    private class RefreshFolderTreeHandler
    extends MailClientHandler {
        private FolderTreeItem folderRoot;

        public RefreshFolderTreeHandler() {
            super(FolderScreen.this.client, "Refreshing folder tree");
        }

        public void runSession() throws IOException, MailException {
            FolderTreeItem folderItem2;
            try {
                folderItem2 = ((IncomingMailClient)this.client).getFolderTree();
            }
            catch (MailException exp) {
                Object folderItem2 = null;
                throw exp;
            }
            AccountCache acctCache = new AccountCache(((IncomingMailClient)this.client).getAcctConfig().getAcctName());
            acctCache.saveFolderTree(folderItem2);
            this.folderRoot = folderItem2;
        }

        public FolderTreeItem getFolderRoot() {
            return this.folderRoot;
        }
    }
}

