/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.PasswordEditField;
import net.rim.device.api.ui.component.Status;
import org.logicprobe.LogicMail.mail.MailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.ui.MailClientHandlerListener;

public abstract class MailClientHandler {
    protected MailClient client;
    private String taskText;
    private MailClientHandlerListener handlerListener;
    private LoginDialog loginDialog;

    public MailClientHandler(MailClient client, String taskText) {
        this.client = client;
        this.taskText = taskText;
        this.handlerListener = null;
    }

    public void setListener(MailClientHandlerListener clientListener) {
        this.handlerListener = clientListener;
    }

    private void showStatus(String message, int time) {
        UiApplication.getUiApplication().invokeLater((Runnable)new StatusRunnable(message, time));
    }

    public void changeStatusMessage(String message) {
        this.showStatus(message, 100000);
    }

    public void start() {
        if (!this.client.isConnected()) {
            String username = this.client.getUsername();
            String password = this.client.getPassword();
            if (username != null && password != null && (username.trim().equals("") || password.trim().equals(""))) {
                this.loginDialog = new LoginDialog(username, password);
                if (this.loginDialog.doModal() == 0) {
                    this.client.setUsername(this.loginDialog.getUsername());
                    this.client.setPassword(this.loginDialog.getPassword());
                } else {
                    this.handlerListener.mailActionComplete(this, false);
                }
            }
        }
        Thread thread = new Thread(){

            public void run() {
                block16: {
                    try {
                        if (!MailClientHandler.this.client.isConnected()) {
                            MailClientHandler.this.showStatus("Connecting to server", 100000);
                            while (!MailClientHandler.this.client.open()) {
                                MailClientHandler.this.loginDialog = new LoginDialog(MailClientHandler.this.client.getUsername(), MailClientHandler.this.client.getPassword());
                                UiApplication.getUiApplication().invokeAndWait(new Runnable(){

                                    public void run() {
                                        MailClientHandler.this.loginDialog.doModal();
                                    }
                                });
                                if (MailClientHandler.this.loginDialog.getSelectedValue() == 0) {
                                    MailClientHandler.this.client.setUsername(MailClientHandler.this.loginDialog.getUsername());
                                    MailClientHandler.this.client.setPassword(MailClientHandler.this.loginDialog.getPassword());
                                    continue;
                                }
                                try {
                                    MailClientHandler.this.client.close();
                                }
                                catch (Exception exp) {
                                    // empty catch block
                                }
                                throw new MailException("Authentication failure");
                            }
                        }
                        MailClientHandler.this.showStatus(MailClientHandler.this.taskText, 100000);
                        MailClientHandler.this.runSession();
                        MailClientHandler.this.showStatus(null, 0);
                        if (MailClientHandler.this.handlerListener != null) {
                            MailClientHandler.this.handlerListener.mailActionComplete(MailClientHandler.this, true);
                        }
                    }
                    catch (IOException exp) {
                        System.out.println(exp);
                        MailClientHandler.this.showStatus("I/O Error", 2000);
                        try {
                            MailClientHandler.this.client.close();
                        }
                        catch (Exception exp2) {
                            // empty catch block
                        }
                        if (MailClientHandler.this.handlerListener != null) {
                            MailClientHandler.this.handlerListener.mailActionComplete(MailClientHandler.this, false);
                        }
                    }
                    catch (MailException exp) {
                        System.out.println("Protocol error: " + exp);
                        MailClientHandler.this.showStatus(exp.getMessage(), 10000);
                        if (MailClientHandler.this.handlerListener != null) {
                            MailClientHandler.this.handlerListener.mailActionComplete(MailClientHandler.this, false);
                        }
                    }
                    catch (Exception exp) {
                        System.out.println("Unknown error: " + exp);
                        MailClientHandler.this.showStatus("Unknown error", 2000);
                        try {
                            MailClientHandler.this.client.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (MailClientHandler.this.handlerListener == null) break block16;
                        MailClientHandler.this.handlerListener.mailActionComplete(MailClientHandler.this, false);
                    }
                }
            }
        };
        thread.start();
    }

    public abstract void runSession() throws IOException, MailException;

    private static class LoginDialog
    extends Dialog {
        private BasicEditField fldUser;
        private PasswordEditField fldPass;

        public LoginDialog(String username, String password) {
            super("Authentication", null, null, 0, Bitmap.getPredefinedBitmap((int)1), 0x40000300000000L);
            this.fldUser = new BasicEditField("Username: ", username);
            this.fldPass = new PasswordEditField("Password: ", password);
            this.add((Field)this.fldUser);
            this.add((Field)this.fldPass);
            this.add((Field)new LabelField((Object)"", 0x80000000000000L));
            ButtonField btnOk = new ButtonField("OK", 0x40000300000000L);
            btnOk.setChangeListener(new FieldChangeListener(){

                public void fieldChanged(Field field, int context) {
                    if (LoginDialog.this.fldUser.getText().length() > 0 && LoginDialog.this.fldPass.getText().length() > 0) {
                        LoginDialog.this.select(0);
                        LoginDialog.this.close();
                    }
                }
            });
            this.add((Field)btnOk);
        }

        public String getUsername() {
            return this.fldUser.getText();
        }

        public String getPassword() {
            return this.fldPass.getText();
        }
    }

    private static class StatusRunnable
    implements Runnable {
        String message;
        int time;

        StatusRunnable(String message, int time) {
            this.message = message;
            this.time = time;
        }

        public void run() {
            try {
                Screen activeScreen = UiApplication.getUiApplication().getActiveScreen();
                if (activeScreen instanceof Status) {
                    UiApplication.getUiApplication().popScreen(activeScreen);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.message != null) {
                Status.show((String)this.message, (int)this.time);
            }
        }
    }
}

