/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import java.util.Calendar;
import net.rim.device.api.i18n.SimpleDateFormat;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.ListFieldCallback;
import net.rim.device.api.ui.component.Menu;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.CompositionScreen;
import org.logicprobe.LogicMail.ui.MailClientHandler;
import org.logicprobe.LogicMail.ui.MailClientHandlerListener;
import org.logicprobe.LogicMail.ui.MessageScreen;

public class MailboxScreen
extends BaseScreen
implements ListFieldCallback,
MailClientHandlerListener {
    private FolderMessage[] messages;
    private ListField msgList;
    private Bitmap bmapOpened;
    private Bitmap bmapUnopened;
    private Bitmap bmapReplied;
    private Bitmap bmapFlagged;
    private Bitmap bmapDraft;
    private Bitmap bmapDeleted;
    private Bitmap bmapUnknown;
    private MailSettings mailSettings;
    private FolderTreeItem folderItem;
    private IncomingMailClient client;
    private RefreshMessageListHandler refreshMessageListHandler;
    private static int lineHeight;
    private static int dateWidth;
    private static int senderWidth;
    private static int maxWidth;
    private MenuItem selectItem = new MenuItem("Select", 100, 10){

        public void run() {
            MailboxScreen.this.openSelectedMessage();
        }
    };
    private MenuItem compositionItem = new MenuItem("Compose E-Mail", 120, 10){

        public void run() {
            UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(MailboxScreen.this.client.getAcctConfig()));
        }
    };

    public MailboxScreen(IncomingMailClient client, FolderTreeItem folderItem) {
        super(folderItem.getName());
        this.mailSettings = MailSettings.getInstance();
        this.folderItem = folderItem;
        this.client = client;
        this.bmapOpened = Bitmap.getBitmapResource((String)"mail_opened.png");
        this.bmapUnopened = Bitmap.getBitmapResource((String)"mail_unopened.png");
        this.bmapReplied = Bitmap.getBitmapResource((String)"mail_replied.png");
        this.bmapFlagged = Bitmap.getBitmapResource((String)"mail_flagged.png");
        this.bmapDraft = Bitmap.getBitmapResource((String)"mail_draft.png");
        this.bmapDeleted = Bitmap.getBitmapResource((String)"mail_deleted.png");
        this.bmapUnknown = Bitmap.getBitmapResource((String)"mail_unknown.png");
        this.messages = new FolderMessage[0];
        this.msgList = new ListField();
        lineHeight = this.msgList.getRowHeight();
        this.msgList.setRowHeight(lineHeight * 2);
        this.msgList.setCallback((ListFieldCallback)this);
        this.add((Field)this.msgList);
        maxWidth = Graphics.getScreenWidth();
        dateWidth = Font.getDefault().getAdvance("00/0000");
        senderWidth = maxWidth - dateWidth - 20;
        if (client != null) {
            this.refreshMessageList();
        }
    }

    private void refreshMessageList() {
        if (this.refreshMessageListHandler == null) {
            this.refreshMessageListHandler = new RefreshMessageListHandler(this.folderItem);
            this.refreshMessageListHandler.setListener(this);
        }
        this.refreshMessageListHandler.start();
    }

    protected boolean onSavePrompt() {
        return true;
    }

    public boolean onClose() {
        if (this.checkClose()) {
            this.close();
            return true;
        }
        return false;
    }

    private boolean checkClose() {
        if (this.client.hasFolders()) {
            return true;
        }
        if (this.client.isConnected()) {
            if (Dialog.ask((int)3, (String)"Disconnect from server?") == 4) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.add(this.selectItem);
        menu.add(this.compositionItem);
        super.makeMenu(menu, instance);
    }

    public void drawListRow(ListField listField, Graphics graphics, int index, int y, int width) {
        if (index >= this.messages.length) {
            return;
        }
        FolderMessage entry = this.messages[index];
        MessageEnvelope env = entry.getEnvelope();
        graphics.drawBitmap(1, y, 20, lineHeight * 2, this.getIconForMessage(entry), 0, 0);
        Font origFont = graphics.getFont();
        graphics.setFont(origFont.derive(1));
        if (env.from != null && env.from.length > 0) {
            graphics.drawText(env.from[0], 20, y, (int)(this.getStyle() | 0x40L), senderWidth);
        }
        graphics.setFont(origFont.derive(0));
        if (env.subject != null) {
            graphics.drawText(env.subject, 20, y + lineHeight, (int)(this.getStyle() | 0x40L), maxWidth - 20);
        }
        graphics.setFont(origFont);
        if (env.date != null) {
            Calendar nowCal = Calendar.getInstance();
            Calendar dispCal = Calendar.getInstance();
            dispCal.setTime(env.date);
            SimpleDateFormat dateFormat = nowCal.get(1) == dispCal.get(1) ? (nowCal.get(2) == dispCal.get(2) && nowCal.get(5) == dispCal.get(5) ? new SimpleDateFormat("h:mma") : new SimpleDateFormat("MM/dd")) : new SimpleDateFormat("MM/yyyy");
            StringBuffer buffer = new StringBuffer();
            dateFormat.format(dispCal, buffer, null);
            graphics.setFont(origFont.derive(1));
            graphics.drawText(buffer.toString(), senderWidth + 20, y, (int)(this.getStyle() | 0x40L), dateWidth);
            graphics.setFont(origFont);
        }
    }

    private Bitmap getIconForMessage(FolderMessage message) {
        if (message.isDeleted()) {
            return this.bmapDeleted;
        }
        if (message.isAnswered()) {
            return this.bmapReplied;
        }
        if (message.isFlagged()) {
            return this.bmapFlagged;
        }
        if (message.isDraft()) {
            return this.bmapDraft;
        }
        if (message.isRecent()) {
            return this.bmapUnopened;
        }
        if (message.isSeen()) {
            return this.bmapOpened;
        }
        return this.bmapUnknown;
    }

    public int getPreferredWidth(ListField listField) {
        return Graphics.getScreenWidth();
    }

    public Object get(ListField listField, int index) {
        return this.messages[index];
    }

    public int indexOfList(ListField listField, String prefix, int start) {
        return 0;
    }

    private void openSelectedMessage() {
        int index = this.msgList.getSelectedIndex();
        if (index < 0 || index > this.messages.length) {
            return;
        }
        UiApplication.getUiApplication().pushScreen((Screen)new MessageScreen(this.client, this.folderItem, this.messages[index]));
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': {
                this.openSelectedMessage();
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mailActionComplete(MailClientHandler source, boolean result) {
        if (source.equals(this.refreshMessageListHandler) && this.refreshMessageListHandler.getFolderMessages() != null) {
            FolderMessage[] folderMessages = this.refreshMessageListHandler.getFolderMessages();
            Object object = Application.getEventLock();
            synchronized (object) {
                int i;
                if (this.mailSettings.getGlobalConfig().getDispOrder()) {
                    this.messages = folderMessages;
                } else {
                    this.messages = new FolderMessage[folderMessages.length];
                    int j = 0;
                    for (i = folderMessages.length - 1; i >= 0; --i) {
                        this.messages[j++] = folderMessages[i];
                    }
                }
                int size = this.msgList.getSize();
                for (i = 0; i < size; ++i) {
                    this.msgList.delete(0);
                }
                for (i = 0; i < this.messages.length; ++i) {
                    this.msgList.insert(i);
                }
                this.msgList.setDirty(true);
            }
        }
    }

    private class RefreshMessageListHandler
    extends MailClientHandler {
        private FolderTreeItem folderItem;
        private FolderMessage[] folderMessages;

        public RefreshMessageListHandler(FolderTreeItem folderItem) {
            super(MailboxScreen.this.client, "Retrieving message list");
            this.folderItem = folderItem;
        }

        public void runSession() throws IOException, MailException {
            FolderMessage[] folderMessages2;
            try {
                ((IncomingMailClient)this.client).setActiveFolder(this.folderItem);
                int firstIndex = this.folderItem.getMsgCount() - MailboxScreen.this.mailSettings.getGlobalConfig().getRetMsgCount();
                if (firstIndex < 0) {
                    firstIndex = 1;
                }
                folderMessages2 = ((IncomingMailClient)this.client).getFolderMessages(firstIndex, this.folderItem.getMsgCount());
            }
            catch (MailException exp) {
                Object folderMessages2 = null;
                throw exp;
            }
            this.folderMessages = folderMessages2;
        }

        public FolderMessage[] getFolderMessages() {
            return this.folderMessages;
        }
    }
}

