/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.IOException;
import java.util.Vector;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.CompositionScreen;
import org.logicprobe.LogicMail.ui.MailClientHandler;
import org.logicprobe.LogicMail.ui.MailClientHandlerListener;
import org.logicprobe.LogicMail.ui.MessageRenderer;
import org.logicprobe.LogicMail.util.StringParser;

public class MessageScreen
extends BaseScreen
implements MailClientHandlerListener {
    private IncomingMailClient client;
    private FolderTreeItem folderItem;
    private FolderMessage folderMessage;
    private MessageEnvelope envelope;
    private Vector msgFields;
    private Message msg;
    private UpdateMessageHandler updateMessageHandler;
    private MenuItem propsItem = new MenuItem("Properties", 100, 10){

        public void run() {
            MessageScreen.this.showMsgProperties();
        }
    };
    private MenuItem replyItem = new MenuItem("Reply...", 110, 10){

        public void run() {
            if (MessageScreen.this.msg != null) {
                UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(MessageScreen.this.client.getAcctConfig(), MessageScreen.this.msg.toReplyMessage()));
            }
        }
    };
    private MenuItem replyAllItem = new MenuItem("Reply to all...", 115, 10){

        public void run() {
            if (MessageScreen.this.msg != null) {
                UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(MessageScreen.this.client.getAcctConfig(), MessageScreen.this.msg.toReplyAllMessage(MessageScreen.this.client.getAcctConfig().getSmtpFromAddress())));
            }
        }
    };
    private MenuItem forwardItem = new MenuItem("Forward...", 120, 10){

        public void run() {
            if (MessageScreen.this.msg != null) {
                UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(MessageScreen.this.client.getAcctConfig(), MessageScreen.this.msg.toForwardMessage()));
            }
        }
    };
    private MenuItem compositionItem = new MenuItem("Compose E-Mail", 150, 10){

        public void run() {
            UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(MessageScreen.this.client.getAcctConfig()));
        }
    };
    private MenuItem closeItem = new MenuItem("Close", 200000, 10){

        public void run() {
            MessageScreen.this.onClose();
        }
    };

    public MessageScreen(IncomingMailClient client, FolderTreeItem folderItem, FolderMessage folderMessage) {
        this.client = client;
        this.folderItem = folderItem;
        this.folderMessage = folderMessage;
        this.envelope = folderMessage.getEnvelope();
        if (this.envelope.from != null && this.envelope.from.length > 0) {
            this.add((Field)new RichTextField("From: " + this.envelope.from[0]));
            if (this.envelope.from.length > 1) {
                for (int i = 1; i < this.envelope.from.length; ++i) {
                    if (this.envelope.from[i] == null) continue;
                    this.add((Field)new RichTextField("      " + this.envelope.from[i]));
                }
            }
        }
        if (this.envelope.subject != null) {
            this.add((Field)new RichTextField("Subject: " + this.envelope.subject));
        }
        this.add((Field)new SeparatorField());
        this.updateMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMessageFields() {
        if (this.msgFields == null) {
            return;
        }
        Object object = Application.getEventLock();
        synchronized (object) {
            int size = this.msgFields.size();
            for (int i = 0; i < size; ++i) {
                if (this.msgFields.elementAt(i) != null) {
                    this.add((Field)this.msgFields.elementAt(i));
                }
                if (i == size - 1) continue;
                this.add((Field)new SeparatorField());
            }
        }
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.add(this.propsItem);
        menu.addSeparator();
        menu.add(this.replyItem);
        menu.add(this.replyAllItem);
        menu.add(this.forwardItem);
        menu.add(this.compositionItem);
        menu.addSeparator();
        menu.add(this.closeItem);
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': 
            case ' ': {
                if (status == 0) {
                    this.scroll(512);
                    retval = true;
                    break;
                }
                if (status != 1) break;
                this.scroll(256);
                retval = true;
            }
        }
        return retval;
    }

    private void showMsgProperties() {
        int i;
        StringBuffer msg = new StringBuffer();
        msg.append("Subject:\n  " + (this.envelope.subject != null ? this.envelope.subject : "") + "\n");
        msg.append("Date:\n  " + (this.envelope.date != null ? StringParser.createDateString(this.envelope.date) : "") + "\n");
        if (this.envelope.from != null && this.envelope.from.length > 0) {
            msg.append("From:\n");
            for (i = 0; i < this.envelope.from.length; ++i) {
                msg.append("  " + (this.envelope.from[i] != null ? this.envelope.from[i] : "") + "\n");
            }
        }
        if (this.envelope.to != null && this.envelope.to.length > 0) {
            msg.append("To:\n");
            for (i = 0; i < this.envelope.to.length; ++i) {
                if (this.envelope.to[i].length() <= 0) continue;
                msg.append("  " + (this.envelope.to[i] != null ? this.envelope.to[i] : "") + "\n");
            }
        }
        if (this.envelope.cc != null && this.envelope.cc.length > 0) {
            msg.append("CC:\n");
            for (i = 0; i < this.envelope.cc.length; ++i) {
                if (this.envelope.cc[i].length() <= 0) continue;
                msg.append("  " + (this.envelope.cc[i] != null ? this.envelope.cc[i] : "") + "\n");
            }
        }
        if (this.envelope.bcc != null && this.envelope.bcc.length > 0) {
            msg.append("BCC:\n");
            for (i = 0; i < this.envelope.bcc.length; ++i) {
                if (this.envelope.bcc[i].length() <= 0) continue;
                msg.append("  " + (this.envelope.bcc[i] != null ? this.envelope.bcc[i] : "") + "\n");
            }
        }
        Dialog dialog = new Dialog(0, msg.toString(), 0, null, 0x2000000L);
        dialog.show();
    }

    private void updateMessage() {
        if (this.updateMessageHandler == null) {
            this.updateMessageHandler = new UpdateMessageHandler();
            this.updateMessageHandler.setListener(this);
        }
        this.updateMessageHandler.start();
    }

    public void mailActionComplete(MailClientHandler source, boolean result) {
        if (source.equals(this.updateMessageHandler) && this.updateMessageHandler.getMessageFields() != null) {
            this.msgFields = this.updateMessageHandler.getMessageFields();
            this.msg = this.updateMessageHandler.getMessage();
            this.drawMessageFields();
        }
    }

    private class UpdateMessageHandler
    extends MailClientHandler {
        private Vector msgFields;
        private Message msg;

        public UpdateMessageHandler() {
            super(MessageScreen.this.client, "Retrieving message");
        }

        public void runSession() throws IOException, MailException {
            ((IncomingMailClient)this.client).setActiveFolder(MessageScreen.this.folderItem);
            this.msg = ((IncomingMailClient)this.client).getMessage(MessageScreen.this.folderMessage);
            if (this.msg.getBody() != null) {
                MessageRenderer msgRenderer = new MessageRenderer();
                this.msg.getBody().accept(msgRenderer);
                this.msgFields = msgRenderer.getMessageFields();
            } else {
                this.msgFields = null;
            }
        }

        public Vector getMessageFields() {
            return this.msgFields;
        }

        public Message getMessage() {
            return this.msg;
        }
    }
}

