/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.StreamConnection;

public class Connection {
    private String serverName;
    private int serverPort;
    private boolean useSSL;
    private boolean deviceSide;
    private StreamConnection socket;
    private String localAddress;
    protected InputStream input;
    protected OutputStream output;
    private static final byte[] CRLF = new byte[]{13, 10};
    private boolean debug;
    private byte[] buffer = new byte[128];
    private int count;
    private static Vector openConnections = new Vector();

    public Connection(String serverName, int serverPort, boolean useSSL, boolean deviceSide) {
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.useSSL = useSSL;
        this.deviceSide = deviceSide;
        this.debug = false;
        this.input = null;
        this.output = null;
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.close();
        Vector vector = openConnections;
        synchronized (vector) {
            if (!openConnections.contains(this)) {
                openConnections.addElement(this);
            }
        }
        String protocolStr = this.useSSL ? "ssl" : "socket";
        String paramStr = this.deviceSide ? ";deviceside=true" : "";
        String connectStr = protocolStr + "://" + this.serverName + ":" + this.serverPort + paramStr;
        if (this.debug) {
            System.out.println("[OPEN] " + connectStr);
        }
        this.socket = (StreamConnection)Connector.open((String)connectStr, (int)3, (boolean)true);
        this.input = this.socket.openDataInputStream();
        this.output = this.socket.openDataOutputStream();
        this.localAddress = ((SocketConnection)this.socket).getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        Vector vector = openConnections;
        synchronized (vector) {
            if (openConnections.contains(this)) {
                openConnections.removeElement(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOpenConnections() {
        boolean result;
        Vector vector = openConnections;
        synchronized (vector) {
            result = !openConnections.isEmpty();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConnections() {
        Vector vector = openConnections;
        synchronized (vector) {
            int size = openConnections.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ((Connection)openConnections.elementAt(i)).close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            openConnections.removeAllElements();
        }
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void send(String s) throws IOException {
        byte[] bytes = s.getBytes();
        int length = bytes.length;
        if (s.length() == 0) {
            if (this.debug) {
                System.out.println("[SEND]");
            }
            this.output.write(CRLF, 0, 2);
        } else {
            int i = 0;
            while (i < length) {
                int j;
                for (j = i; j < length && bytes[j] != 10 && bytes[j] != 13; ++j) {
                }
                if (this.debug) {
                    System.out.println("[SEND] " + s.substring(i, j));
                }
                this.output.write((s.substring(i, j) + "\r\n").getBytes());
                if (j < length - 1 && bytes[j] == 13 && bytes[j + 1] == 10) {
                    ++j;
                }
                i = j + 1;
            }
        }
        this.output.flush();
    }

    public void sendCommand(String s) throws IOException {
        if (this.debug) {
            System.out.println("[SEND] " + s);
        }
        if (s == null) {
            this.output.write(CRLF, 0, 2);
        } else {
            this.output.write((s + "\r\n").getBytes());
        }
        this.output.flush();
    }

    public void sendRaw(String s) throws IOException {
        byte[] bytes = s.getBytes();
        int length = bytes.length;
        if (this.debug) {
            System.out.println("[SEND] " + s);
        }
        this.output.write(bytes, 0, bytes.length);
        this.output.flush();
    }

    public String receive() throws IOException {
        StringBuffer resultBuffer = new StringBuffer();
        boolean stop = false;
        while (!stop) {
            this.count = 0;
            while (true) {
                int actual;
                if ((actual = this.input.read(this.buffer, this.count, 1)) == -1) {
                    try {
                        this.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw new IOException("Connection closed");
                }
                if (actual == 0) {
                    try {
                        Thread.yield();
                    }
                    catch (Exception ignored) {}
                    continue;
                }
                byte b = this.buffer[this.count];
                if (b == 13) continue;
                if (b == 10) {
                    stop = true;
                    break;
                }
                ++this.count;
                if (this.count == this.buffer.length) break;
            }
            resultBuffer.append(new String(this.buffer, 0, this.count));
        }
        if (this.debug) {
            System.out.println("[RECV] " + resultBuffer.toString());
        }
        return resultBuffer.toString();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }
}

