/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import net.rim.device.api.util.Arrays;
import net.rim.device.api.util.DateTimeUtilities;
import net.rim.device.api.util.NumberUtilities;

public class StringParser {
    private StringParser() {
    }

    public static Date parseDateString(String rawDate) {
        String tz;
        int p = 0;
        int q = 0;
        int[] fields = new int[7];
        p = rawDate.indexOf(",");
        if (p != -1) {
            ++p;
            while (rawDate.charAt(p) == ' ') {
                ++p;
            }
            rawDate = rawDate.substring(p);
        }
        if (rawDate.charAt(rawDate.length() - 1) == ')') {
            rawDate = rawDate.substring(0, rawDate.lastIndexOf(32));
        }
        Calendar cal = (tz = rawDate.substring(rawDate.lastIndexOf(32) + 1)).startsWith("-") || tz.startsWith("+") ? Calendar.getInstance(TimeZone.getTimeZone("GMT" + tz)) : Calendar.getInstance(TimeZone.getTimeZone(tz));
        p = 0;
        q = rawDate.indexOf(" ", p + 1);
        fields[2] = Integer.parseInt(rawDate.substring(p, q));
        p = q + 1;
        String monthStr = rawDate.substring(p, q = rawDate.indexOf(" ", p + 1));
        if (monthStr.equals("Jan")) {
            fields[1] = 0;
        } else if (monthStr.equals("Feb")) {
            fields[1] = 1;
        } else if (monthStr.equals("Mar")) {
            fields[1] = 2;
        } else if (monthStr.equals("Apr")) {
            fields[1] = 3;
        } else if (monthStr.equals("May")) {
            fields[1] = 4;
        } else if (monthStr.equals("Jun")) {
            fields[1] = 5;
        } else if (monthStr.equals("Jul")) {
            fields[1] = 6;
        } else if (monthStr.equals("Aug")) {
            fields[1] = 7;
        } else if (monthStr.equals("Sep")) {
            fields[1] = 8;
        } else if (monthStr.equals("Oct")) {
            fields[1] = 9;
        } else if (monthStr.equals("Nov")) {
            fields[1] = 10;
        } else if (monthStr.equals("Dec")) {
            fields[1] = 11;
        }
        p = q + 1;
        q = rawDate.indexOf(" ", p + 1);
        fields[0] = Integer.parseInt(rawDate.substring(p, q));
        p = q + 1;
        q = rawDate.indexOf(":", p + 1);
        fields[3] = Integer.parseInt(rawDate.substring(p, q));
        p = q + 1;
        q = rawDate.indexOf(":", p + 1);
        fields[4] = Integer.parseInt(rawDate.substring(p, q));
        p = q + 1;
        q = rawDate.indexOf(" ", p + 1);
        fields[5] = Integer.parseInt(rawDate.substring(p, q));
        fields[6] = 0;
        DateTimeUtilities.setCalendarFields((Calendar)cal, (int[])fields);
        return cal.getTime();
    }

    public static String createDateString(Date time) {
        return StringParser.createDateString(time, TimeZone.getDefault());
    }

    public static String createDateString(Date time, TimeZone zone) {
        Calendar cal = Calendar.getInstance(zone);
        cal.setTime(time);
        StringBuffer buf = new StringBuffer();
        switch (cal.get(7)) {
            case 1: {
                buf.append("Sun, ");
                break;
            }
            case 2: {
                buf.append("Mon, ");
                break;
            }
            case 3: {
                buf.append("Tue, ");
                break;
            }
            case 4: {
                buf.append("Wed, ");
                break;
            }
            case 5: {
                buf.append("Thu, ");
                break;
            }
            case 6: {
                buf.append("Fri, ");
                break;
            }
            case 7: {
                buf.append("Sat, ");
            }
        }
        buf.append(cal.get(5));
        buf.append(' ');
        switch (cal.get(2)) {
            case 0: {
                buf.append("Jan ");
                break;
            }
            case 1: {
                buf.append("Feb ");
                break;
            }
            case 2: {
                buf.append("Mar ");
                break;
            }
            case 3: {
                buf.append("Apr ");
                break;
            }
            case 4: {
                buf.append("May ");
                break;
            }
            case 5: {
                buf.append("Jun ");
                break;
            }
            case 6: {
                buf.append("Jul ");
                break;
            }
            case 7: {
                buf.append("Aug ");
                break;
            }
            case 8: {
                buf.append("Sep ");
                break;
            }
            case 9: {
                buf.append("Oct ");
                break;
            }
            case 10: {
                buf.append("Nov ");
                break;
            }
            case 11: {
                buf.append("Dec ");
            }
        }
        buf.append(cal.get(1));
        buf.append(' ');
        buf.append(NumberUtilities.toString((int)cal.get(11), (int)10, (int)2));
        buf.append(':');
        buf.append(NumberUtilities.toString((int)cal.get(12), (int)10, (int)2));
        buf.append(':');
        buf.append(NumberUtilities.toString((int)cal.get(13), (int)10, (int)2));
        buf.append(' ');
        int tzOffset = cal.getTimeZone().getRawOffset() / 36000;
        if (tzOffset < 0) {
            buf.append(NumberUtilities.toString((int)tzOffset, (int)10, (int)5));
        } else {
            buf.append("+");
            buf.append(NumberUtilities.toString((int)tzOffset, (int)10, (int)4));
        }
        return buf.toString();
    }

    public static Vector nestedParenStringLexer(String rawText) {
        int p;
        Vector<Object> parsedText = new Vector<Object>();
        if (rawText.charAt(0) != '(' || rawText.charAt(rawText.length() - 1) != ')') {
            return null;
        }
        boolean inQuote = false;
        for (int q = p = 1; q < rawText.length(); ++q) {
            if (rawText.charAt(q) == '\"') {
                if (!inQuote) {
                    inQuote = true;
                    p = q;
                    continue;
                }
                parsedText.addElement(rawText.substring(p + 1, q));
                p = q + 1;
                inQuote = false;
                continue;
            }
            if (rawText.charAt(q) == '{' && !inQuote) {
                p = rawText.indexOf(125, q);
                int len = Integer.parseInt(rawText.substring(q + 1, p));
                ++p;
                while (rawText.charAt(p) == '\r' || rawText.charAt(p) == '\n') {
                    ++p;
                }
                String tmpText = rawText.substring(p, p + len);
                if (tmpText.endsWith(" NIL")) {
                    len -= 4;
                } else if (tmpText.endsWith(" NI")) {
                    len -= 3;
                } else if (tmpText.endsWith(" N")) {
                    len -= 2;
                } else if (tmpText.endsWith(" ")) {
                    --len;
                }
                parsedText.addElement(rawText.substring(p, p + len));
                q = p + len;
                continue;
            }
            if (rawText.charAt(q) == ' ' && !inQuote || q == rawText.length() - 1) {
                if (q - p > 0) {
                    parsedText.addElement(rawText.substring(p, q).trim());
                    p = q;
                    continue;
                }
                ++p;
                continue;
            }
            if (rawText.charAt(q) != '(' || inQuote) continue;
            p = q;
            int level = 0;
            boolean subInQuote = false;
            for (int i = q + 1; i < rawText.length(); ++i) {
                int matchIndex;
                if (rawText.charAt(i) == '{' && !subInQuote && (matchIndex = rawText.indexOf(125, i)) > i + 1 && rawText.charAt(matchIndex + 1) != ' ') {
                    int matchLen = Integer.parseInt(rawText.substring(i + 1, matchIndex));
                    ++matchIndex;
                    while (rawText.charAt(matchIndex) == '\r' || rawText.charAt(matchIndex) == '\n') {
                        ++matchIndex;
                    }
                    i = matchIndex + matchLen;
                }
                if (rawText.charAt(i) == '\"' && !subInQuote) {
                    subInQuote = true;
                } else if (rawText.charAt(i) == '\"' && subInQuote) {
                    subInQuote = false;
                }
                if (rawText.charAt(i) == '(' && !subInQuote) {
                    ++level;
                    continue;
                }
                if (rawText.charAt(i) != ')' || subInQuote) continue;
                if (level == 0) {
                    q = i;
                    break;
                }
                --level;
            }
            if (q == 1 || q < p) {
                return null;
            }
            parsedText.addElement(StringParser.nestedParenStringLexer(rawText.substring(p, q + 1)));
            p = q + 1;
        }
        return parsedText;
    }

    public static Hashtable parseMailHeaders(String[] rawLines) {
        String line = "";
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < rawLines.length; ++i) {
            if (rawLines[i].startsWith(" ") || rawLines[i].startsWith("\t")) {
                line = line + "\r\n" + rawLines[i];
            } else {
                if (line.length() != 0) {
                    table.put(line.substring(0, line.indexOf(58)).toLowerCase(), line.substring(line.indexOf(32) + 1));
                }
                line = rawLines[i];
            }
            if (i != rawLines.length - 1 || line.length() == 0) continue;
            table.put(line.substring(0, line.indexOf(58)).toLowerCase(), line.substring(line.indexOf(32) + 1));
        }
        return table;
    }

    public static String[] parseTokenString(String text, String token) {
        Object[] tok = new String[]{};
        if (text == null) {
            return tok;
        }
        int p = 0;
        int q = 0;
        while (q < text.length()) {
            q = text.indexOf(token, p + 1);
            if (q == -1) {
                Arrays.add((Object[])tok, (Object)text.substring(p));
                break;
            }
            Arrays.add((Object[])tok, (Object)text.substring(p, q));
            p = q + token.length();
        }
        return tok;
    }

    public static String parseValidCharsetString(String encoding) {
        if (encoding == null) {
            return "ISO-8859-1";
        }
        if (encoding.toUpperCase().indexOf("ISO-8859-1") != -1) {
            return "ISO-8859-1";
        }
        if (encoding.toUpperCase().indexOf("UTF-8") != -1) {
            return "UTF-8";
        }
        if (encoding.toUpperCase().indexOf("UTF-16BE") != -1) {
            return "UTF-16BE";
        }
        if (encoding.toUpperCase().indexOf("US-ASCII") != -1) {
            return "US-ASCII";
        }
        return "ISO-8859-1";
    }

    public static InputStream createInputStream(String[] rawLines) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < rawLines.length; ++i) {
            buf.append(rawLines[i] + "\r\n");
        }
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    public static byte[] readWholeStream(InputStream is) throws IOException {
        byte[] tmpBuf;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (is.available() > 0 && is.read(tmpBuf = new byte[is.available()]) >= 0) {
            bos.write(tmpBuf);
        }
        return bos.toByteArray();
    }

    public static String decodeQuotedPrintable(String text) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int length = text.length();
        while (index < length) {
            if (text.charAt(index) == '=') {
                if (index + 2 >= length) break;
                try {
                    int charVal = Integer.parseInt(text.substring(index + 1, index + 3), 16);
                    buffer.append((char)charVal);
                }
                catch (NumberFormatException exp) {
                    // empty catch block
                }
                index += 3;
                continue;
            }
            buffer.append(text.charAt(index));
            ++index;
        }
        return buffer.toString();
    }

    public static String encodeQuotedPrintable(String text) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch < '\u0080') {
                buffer.append(ch);
                continue;
            }
            String charStr = Integer.toHexString(ch);
            buffer.append('=');
            if (charStr.length() == 1) {
                buffer.append('0');
            }
            buffer.append(charStr);
        }
        return buffer.toString();
    }
}

