/***********************************************************************

SlapEnable.h

Purpose: 	Enables an application to be slap compatible.

Copyright  2000 Hands High Software
All Rights Reserved
************************************************************************/

#ifndef _H_SlapEnable
#define _H_SlapEnable

#define SlapCreator	'HSLP'
#define SlapFeatureNum 500

#define SlapLaunchCode 49133	/* Hope this doesn't conflict */

/******************************************

Launch code parameters for the slap launch

Your application will be launched WITH globals and
your application will be expected to create a new record with the
data and immediately go to it as if a Goto happened.

Call SlapGetText to get a pointer to the text. Call SlapReleaseParams when
you are done creating your record.

*******************************************/

typedef struct {
	UInt16		    slapDBCard;
	LocalID			slapDBLocalID;
	UInt16			slapRecord;
	UInt32	  		start;	// starting position of user selection
	UInt32	  		end;	// ending position of user selection
	DmOpenRef		dbRef;	// not coming in, but used by SlapGetText
} SlapLaunchParamsType, *SlapLaunchParamsPtr;

void SlapInit (UInt32 appCreator);
char * SlapGetText(SlapLaunchParamsPtr pParams);
void SlapReleaseParams(SlapLaunchParamsPtr pParams);

#endif