/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Font;
import waba.io.Catalog;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.ui.ComboBox;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.Label;
import waba.ui.MainWindow;
import waba.ui.MenuBar;
import waba.ui.MessageBox;
import waba.util.Vector;

public class Welcome
extends MainWindow {
    private MenuBar f1;

    public Welcome() {
        super("Welcome", (byte)4);
        this.setDoubleBuffer(true);
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 499: {
                if (event.target != this.f1) break;
                switch (this.f1.getSelectedMenuItem()) {
                    case 3: {
                        this.exit(0);
                        return;
                    }
                    case 201: {
                        this.popupModal(new MessageBox("About", "SuperWaba Virtual Machine|www.superwaba.org|Copyright (c) 2000-2003|Guilherme Campos Hazan||SuperWaba is an enhanced version|of the Waba Virtual Machine|Copyright (c) 1998,1999 WabaSoft|www.wabasoft.com"));
                        return;
                    }
                    case 203: {
                        this.popupModal(new MessageBox("License", "SuperWaba Virtual Machine|Copyright (C) 2000-2003|Guilherme Campos Hazan|<guich@superwaba.org.>|Copyright (C) 1998, 1999 Wabasoft|<www.wabasoft.com>,|All Rights Reserved||This library and virtual machine is|free software; you can redistribute|it and/or modify it under the terms|of the Amended GNU Lesser General|Public License distributed with this|software. This library and virtual|machine is distributed in the hope|that it will be useful, but WITHOUT|ANY WARRANTY; without even|the implied warranty of|MERCHANTABILITY or FITNESS FOR A|PARTICULAR PURPOSE.|All software that links or interacts|with this library and virtual machine,|or any derivative works, require the|software to prominently display|the following notice:||Created with SuperWaba|http://www.superwaba.org||Please see the software license|located at superwaba/license.txt|for more details. You should have|received a copy of the License along|with this software; if not, write to||Guilherme Campos Hazan|Av. Nossa Senhora de Copacabana|728 apto 605|Copacabana|Rio de Janeiro / RJ - Brazil|Cep: 22050-000|E-mail: guich@superwaba.org"));
                    }
                }
            }
        }
    }

    public void onExit() {
        boolean bl = this.f1.isChecked(101);
        boolean bl2 = this.f1.isChecked(102);
        if (!bl && !bl2) {
            Settings.appSettings = null;
            return;
        }
        Settings.appSettings = String.valueOf(bl ? "1" : "0") + (bl2 ? "1" : "0");
    }

    public void onStart() {
        int n;
        Object object;
        String[] stringArray = new String[]{"File", "*Beam...", "-", "Exit"};
        String[] stringArray2 = new String[]{"VM", "?Audible GC", "?Dump Memory Stats"};
        String[] stringArray3 = new String[]{"?", "About", "-", "License"};
        this.f1 = new MenuBar(new String[][]{stringArray, stringArray2, stringArray3});
        this.setMenuBar(this.f1);
        if (Settings.isColor) {
            this.f1.setBackForeColors(new Color(0, 0, 255), Color.WHITE);
            this.f1.setCursorColor(new Color(100, 100, 255));
            this.f1.setBorderStyle((byte)0);
            this.f1.setPopColors(new Color(0, 120, 255), new Color(0, 255, 255), null);
        }
        Label label = new Label("SuperWaba Virtual Machine");
        label.setInvert(true);
        label.setFont(new Font("SW", 1, 14));
        this.add(label, 120000, 140015);
        this.add(new Label("Version " + Settings.versionStr + " for " + Settings.platform), 120000, 190003);
        this.add(new Label("Virtual Machine installed and ready"), 120000, 190012);
        Vector vector = new Vector();
        if (!Settings.onDevice) {
            vector.add("This program");
        } else {
            object = Catalog.listCatalogs(0, Convert.chars2int("Wrp2"));
            n = ((String[])object).length;
            int n2 = 0;
            while (n2 < n) {
                if (object[n2] != null) {
                    int n3 = object[n2].lastIndexOf(33) != -1 ? 1 : 0;
                    vector.add(((String)object[n2]).substring(0, ((String)object[n2]).indexOf(46) - n3));
                }
                ++n2;
            }
            vector.del("SuperWaba");
            vector.qsort();
        }
        if (vector.size() == 0) {
            this.add(new Label("No SuperWaba programs installed"), 120000, 120010);
        } else {
            this.add(new Label("List of currently installed programs:"), 120000, 120010);
            object = new ComboBox(vector.toObjectArray());
            this.add((Control)object, 120000, 190005);
            ((ComboBox)object).select(0);
            this.add(new Label("(They can't be launched from here!)"), 120000, 190002);
        }
        this.add(new Label("Click title or menu for options"), 120000, 149998);
        if (Settings.appSettings != null && Settings.appSettings.length() == 2) {
            boolean bl = Settings.appSettings.charAt(0) == '1';
            int n4 = n = Settings.appSettings.charAt(1) != '1' ? 0 : 1;
            if (bl) {
                this.f1.setChecked(101, true);
            }
            if (n != 0) {
                this.f1.setChecked(102, true);
            }
        }
    }
}

