/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.io.DataStream;
import waba.util.IntHashtable$Entry;
import waba.util.IntVector;

public final class IntHashtable {
    public static int INVALID = Integer.MIN_VALUE;
    private IntHashtable$Entry[] f1;
    private transient int f2;
    private int f3;
    private float f4;

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable(int n, float f) {
        if (n <= 0) {
            n = 5;
        }
        this.f4 = f;
        this.f1 = new IntHashtable$Entry[n];
        this.f3 = (int)((float)n * f);
    }

    public IntHashtable(DataStream dataStream) {
        this.f1 = new IntHashtable$Entry[dataStream.readInt()];
        this.f4 = dataStream.readFloat();
        this.f3 = dataStream.readInt();
        int n = dataStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.put(dataStream.readInt(), dataStream.readInt());
            ++n2;
        }
    }

    public void clear() {
        IntHashtable$Entry[] intHashtable$EntryArray = this.f1;
        int n = this.f1.length;
        while (--n >= 0) {
            intHashtable$EntryArray[n] = null;
        }
        this.f2 = 0;
    }

    public int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.f1.length;
        IntHashtable$Entry intHashtable$Entry = this.f1[n2];
        while (intHashtable$Entry != null) {
            if (intHashtable$Entry.key == n) {
                return intHashtable$Entry.value;
            }
            intHashtable$Entry = intHashtable$Entry.next;
        }
        return INVALID;
    }

    public IntVector getKeys() {
        IntVector intVector = new IntVector(this.size());
        int n = this.f1.length;
        int n2 = 0;
        while (n2 < n) {
            IntHashtable$Entry intHashtable$Entry = this.f1[n2];
            if (intHashtable$Entry != null) {
                intVector.add(intHashtable$Entry.key);
                while (intHashtable$Entry.next != null) {
                    intHashtable$Entry = intHashtable$Entry.next;
                    intVector.add(intHashtable$Entry.key);
                }
            }
            ++n2;
        }
        return intVector;
    }

    public int put(int n, int n2) {
        if (n == INVALID || n2 == INVALID) {
            return INVALID;
        }
        IntHashtable$Entry[] intHashtable$EntryArray = this.f1;
        int n3 = (n & Integer.MAX_VALUE) % intHashtable$EntryArray.length;
        IntHashtable$Entry intHashtable$Entry = intHashtable$EntryArray[n3];
        while (intHashtable$Entry != null) {
            if (intHashtable$Entry.key == n) {
                int n4 = intHashtable$Entry.value;
                intHashtable$Entry.value = n2;
                return n4;
            }
            intHashtable$Entry = intHashtable$Entry.next;
        }
        if (this.f2 >= this.f3) {
            this.rehash();
            return this.put(n, n2);
        }
        IntHashtable$Entry intHashtable$Entry2 = new IntHashtable$Entry(this);
        new IntHashtable$Entry(this).key = n;
        intHashtable$Entry2.value = n2;
        intHashtable$Entry2.next = intHashtable$EntryArray[n3];
        intHashtable$EntryArray[n3] = intHashtable$Entry2;
        ++this.f2;
        return INVALID;
    }

    protected void rehash() {
        int n = this.f1.length;
        IntHashtable$Entry[] intHashtable$EntryArray = this.f1;
        int n2 = ((n << 1) + n >> 1) + 1;
        IntHashtable$Entry[] intHashtable$EntryArray2 = new IntHashtable$Entry[n2];
        this.f3 = (int)((float)n2 * this.f4);
        this.f1 = intHashtable$EntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntHashtable$Entry intHashtable$Entry = intHashtable$EntryArray[n3];
            while (intHashtable$Entry != null) {
                IntHashtable$Entry intHashtable$Entry2 = intHashtable$Entry;
                intHashtable$Entry = intHashtable$Entry.next;
                int n4 = (intHashtable$Entry2.key & Integer.MAX_VALUE) % n2;
                intHashtable$Entry2.next = intHashtable$EntryArray2[n4];
                intHashtable$EntryArray2[n4] = intHashtable$Entry2;
            }
        }
    }

    public int remove(int n) {
        IntHashtable$Entry[] intHashtable$EntryArray = this.f1;
        int n2 = (n & Integer.MAX_VALUE) % intHashtable$EntryArray.length;
        IntHashtable$Entry intHashtable$Entry = intHashtable$EntryArray[n2];
        IntHashtable$Entry intHashtable$Entry2 = null;
        while (intHashtable$Entry != null) {
            if (intHashtable$Entry.key == n) {
                if (intHashtable$Entry2 != null) {
                    intHashtable$Entry2.next = intHashtable$Entry.next;
                } else {
                    intHashtable$EntryArray[n2] = intHashtable$Entry.next;
                }
                --this.f2;
                return intHashtable$Entry.value;
            }
            intHashtable$Entry2 = intHashtable$Entry;
            intHashtable$Entry = intHashtable$Entry.next;
        }
        return INVALID;
    }

    public void saveTo(DataStream dataStream) {
        dataStream.writeInt(this.f1.length);
        dataStream.writeFloat(this.f4);
        dataStream.writeInt(this.f3);
        dataStream.writeInt(this.f2);
        int n = this.f1.length;
        int n2 = 0;
        while (n2 < n) {
            IntHashtable$Entry intHashtable$Entry = this.f1[n2];
            if (intHashtable$Entry != null) {
                dataStream.writeInt(intHashtable$Entry.key);
                dataStream.writeInt(intHashtable$Entry.value);
                while (intHashtable$Entry.next != null) {
                    intHashtable$Entry = intHashtable$Entry.next;
                    dataStream.writeInt(intHashtable$Entry.key);
                    dataStream.writeInt(intHashtable$Entry.value);
                }
            }
            ++n2;
        }
    }

    public int size() {
        return this.f2;
    }
}

