/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.model;

import com.ibm.weme.examples.golftracker.IGolfHole;
import com.ibm.weme.examples.golftracker.model.GolfCourse;

public final class GolfHole
implements IGolfHole {
    private int score;
    private int par;
    private int yardage;
    private int number;
    private GolfCourse course;
    private String mapFileName;

    public GolfHole(GolfCourse course, int number, int yardage, int par, String mapFileName) {
        this.course = course;
        this.number = number;
        this.yardage = yardage;
        this.par = par;
        this.mapFileName = mapFileName;
    }

    public final int getNumber() {
        return this.number;
    }

    public final boolean hasNext() {
        return this.number < this.course.getLastHoleNumber();
    }

    public final boolean hasPrevious() {
        return this.number > this.course.getFirstHoleNumber();
    }

    public final int getPar() {
        return this.par;
    }

    public final int getYardage() {
        return this.yardage;
    }

    public final int getScore() {
        return this.score;
    }

    public final int getRelativeScore() {
        return this.score - this.par;
    }

    public final void setScore(int score) {
        this.score = score;
    }

    public final boolean hasScore() {
        return this.score > 0;
    }

    public final String getMapFileName() {
        return this.mapFileName;
    }
}

