package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

public interface IPlatformRequestHandler {

	/**
	 * This method is ivoked when the implementor of this
	 * interface is required to handle the request specified by
	 * the url.
	 * @param url - the url including schema for the platform request
	 */
	public void handleRequest(String url);

	/**
	 * Answers true when the implementor of this interface can
	 * handle the specfied ur.
	 * @param url - the url including schema for the platform request
	 * @return boolean
	 */
	public boolean handlesURL(String url);

}
