package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

import java.io.*;

import com.ibm.ive.midp.util.*;

/**
 * This class retrieves strings from a resource bundle
 * and returns them, formatting them with MessageFormat
 * when required.
 * <p>
 * It is used by the system classes to provide national
 * language support, by looking up messages in the
 * <code>
 *    com.ibm.oti.util.ExternalMessages
 * </code>
 * resource bundle. Note that if this file is not available,
 * or an invalid key is looked up, or resource bundle support
 * is not available, the key itself will be returned as the
 * associated message. This means that the <em>KEY</em> should
 * a reasonable human-readable (english) string.
 *
 * @author		OTI
 * @version		initial
 */

import java.util.*;

public class MsgDrawnCommon {

	// Properties holding the system messages.
	static private Hashtable messages = null;

	static {
	  // Attempt to load the messages.
	  try {
		messages = MsgHelp.loadMessages("com/ibm/ive/midp/ExternalMessagesDrawnCommon"); //$NON-NLS-1$
	  } catch (IOException e) {}
	}

/**
 * Retrieves a message which has no arguments.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		msg String
 *					the key to look up.
 * @return		String
 *					the message for that key in the system
 *					message bundle.
 */
static public String getString (String msg) {
	if (messages==null)
		return msg;
	String resource = (String)messages.get(msg);
	if (resource==null)
		return msg;
	return resource;
}

/**
 * Retrieves a message which takes 1 argument.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		msg String
 *					the key to look up.
 * @param		arg Object
 *					the object to insert in the formatted output.
 * @return		String
 *					the message for that key in the system
 *					message bundle.
 */
static public String getString (String msg, Object arg) {
	return getString(msg, new Object[] {arg});
}

/**
 * Retrieves a message which takes 1 integer argument.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		msg String
 *					the key to look up.
 * @param		arg int
 *					the integer to insert in the formatted output.
 * @return		String
 *					the message for that key in the system
 *					message bundle.
 */
static public String getString (String msg, int arg) {
	return getString(msg, new Object[] {Integer.toString(arg)});
}

/**
 * Retrieves a message which takes 1 character argument.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		msg String
 *					the key to look up.
 * @param		arg char
 *					the character to insert in the formatted output.
 * @return		String
 *					the message for that key in the system
 *					message bundle.
 */
static public String getString (String msg, char arg) {
	return getString(msg, new Object[] {String.valueOf(arg)});
}

/**
 * Retrieves a message which takes 2 arguments.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		msg String
 *					the key to look up.
 * @param		arg1 Object
 *					an object to insert in the formatted output.
 * @param		arg2 Object
 *					another object to insert in the formatted output.
  * @return		String
 *					the message for that key in the system
 *					message bundle.
 */
static public String getString (String msg, Object arg1, Object arg2) {
	return getString(msg, new Object[] {arg1, arg2});
}

/**
 * Retrieves a message which takes several arguments.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		msg String
 *					the key to look up.
 * @param		args Object[]
 *					the objects to insert in the formatted output.
 * @return		String
 *					the message for that key in the system
 *					message bundle.
 */
static public String getString (String msg, Object[] args) {
	String format = msg;

	if (messages != null) {
		format = (String)messages.get(msg);
		if (format==null) format = msg;
	}

	return MsgHelp.format(format, args);
}
}
