package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

public class AmsException extends Exception {

	int status = 0;
	String data = ""; //$NON-NLS-1$
	String fNotifyURL = null;

	public AmsException(int statusCode) {
		this(statusCode, null, null);
	}

	public AmsException(int statusCode, String message) {
		this(statusCode, message, null);
	}

	public AmsException(int statusCode, String message, String notifyURL) {
		super(message == null ? "" : message); //$NON-NLS-1$
		status = statusCode;
		fNotifyURL = notifyURL;
	}

	public String getMessage() {
		String message = super.getMessage();
		return message == null ? "" : message; //$NON-NLS-1$
	}

	public String getNotifyURL() {
		return fNotifyURL;
	}

	public int getStatus() {
		return status;
	}
}
