package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.*;
import java.util.*;
import javax.microedition.io.*;
import javax.microedition.pki.CertificateException;
import com.ibm.ive.midp.*;
import com.ibm.oti.security.midp.KeyStore;
import com.ibm.oti.security.provider.*;
import com.ibm.ive.midp.util.*;
import com.ibm.oti.util.*;

class AmsMidletSecurityOfficer{

	public static void main(String[] args) throws Exception {
        InputConnection jadConn = (InputConnection) Connector.open("file:" + args[0]); //$NON-NLS-1$
        int posStart = args[0].lastIndexOf('/');
        if (posStart==-1) posStart = args[0].lastIndexOf(':');
        if (posStart==-1) posStart = 0;
        String jadName = args[0].substring(posStart);
        Hashtable jad = JadParser.parse(jadName);
        InputConnection jarConn = (InputConnection)Connector.open("file:" + args[1]); //$NON-NLS-1$
        verify(jad, jarConn.openInputStream());
        jadConn.close();
        jarConn.close();
    }
	public static X500Principal verify(Hashtable jadProperties, InputStream jarStream) throws SecurityException, CertificateException, IOException {
		X509Certificate[] chain = null;
		Exception chainException = null;
		int i = 1;
		int chainlen;
		while (true) {
			try {
				// find the chain length
				chainlen = 0;
				while (jadProperties.get("MIDlet-Certificate-" + i + "-" + (chainlen + 1)) != null) { //$NON-NLS-1$ //$NON-NLS-2$
					chainlen++;
				}
				if (chainlen == 0) {
					chain = null;
					break;
				}

				// parse the certificates in the chain
				chain = new X509Certificate[chainlen];
				for(int j = 0; j < chainlen; j++) {
					byte[] certBytes = ((String)jadProperties.get("MIDlet-Certificate-" + i + "-" + (j + 1))).getBytes(); //$NON-NLS-1$ //$NON-NLS-2$
					chain[j] = X509Certificate.certificateFromASN1Object(BASE64Decoder.decode(certBytes));
				}

				CertificateVerifier.verifyCertificateChain(chain, new Date(), CertificateVerifier.USAGE_MIDLET_SUITE_INSTALL);
				// no exception thrown, therefore this is a valid chain
				break;
			} catch (CertificateException e) {
				// cache the exception if it is the first and try the next chain
				if (chainException==null) chainException = e;
				chain = null;
			} catch (SecurityException e) {
				if (chainException==null) chainException = e;
				chain = null;
			}
			i++;
		}

		if (chain == null) {
			if (chainException instanceof CertificateException) throw (CertificateException)chainException;
			if (chainException instanceof SecurityException) throw (SecurityException)chainException;
			throw new SecurityException(MidpMsg.getString("AmsMidletSecurityOfficer.verify.error.no_certificate_chain")); //$NON-NLS-1$
		}

		// verify the jar signature
		String jarHashEnc = (String)jadProperties.get("MIDlet-Jar-RSA-SHA1"); //$NON-NLS-1$
		if (jarHashEnc == null) throw new SecurityException(MidpMsg.getString("AmsMidletSecurityOfficer.verify.error.no_hash_value")); //$NON-NLS-1$
		byte[] jarHash = BASE64Decoder.decode(jarHashEnc.getBytes());
		PKCS1 pkcs1 = new PKCS1("SHA1"); //$NON-NLS-1$
		try {
			RSAPublicKey signkey = new RSAPublicKey(chain[0].getPublicKey());
			if (!pkcs1.verifySSA_PKCS1_v15(signkey, jarStream, jarHash)) throw new SecurityException(MidpMsg.getString("AmsMidletSecurityOfficer.verify.error.incorrect_jar_signature")); //$NON-NLS-1$
		} catch (ASN1Exception e) {
			throw new SecurityException(MidpMsg.getString("AmsMidletSecurityOfficer.verify.error.error_reading_certificate")); //$NON-NLS-1$
		}

		X509Certificate rootCert = chain[chain.length - 1];
		X500Principal rootDN = new X500Principal(rootCert.getIssuer());
		return rootDN;
    }

	public static String getSecurityDomain(X500Principal rootDN) {
		KeyStore.Entry entry = KeyStore.getSystemKeyStore().getEntry(rootDN);
		String domain = entry != null ? entry.getProtectionDomain() : "untrusted"; //$NON-NLS-1$
		return domain;
	}
}
