package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.util.*;
import java.util.Hashtable;

public class CldcTester {

	static final String MAIN_CLASS = "Main-Class";
	static final String JAR_URL = "JAR-File-URL";

	String fDebugArgs;
	LaunchConfiguration fConfiguartion;

	public CldcTester(LaunchConfiguration launchConfiguration, String debugArgs) {
		super();
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		fConfiguartion = launchConfiguration;
		fDebugArgs = debugArgs;
	}

	public void runTests(String url) {
		ConsoleBasedInstallListener listener = new ConsoleBasedInstallListener(true);
		FileDownloader downloader = new FileDownloader(listener);

		while (true) {
			// Download the jad file
			String jadFileName = FileStorage.getNextAvailableFileName(".jad");
			try {
				downloader.downloadFile(url, jadFileName);
			} catch (AmsException e) {
				e.printStackTrace();
				return;
			}
			Hashtable jadProperties = JadParser.parse(jadFileName);

			// Download the jar file
			String jarUrl = (String) jadProperties.get(JAR_URL);
			String jarFileName = FileStorage.getNextAvailableFileName(".jar");
			try {
				downloader.downloadFile(jarUrl, jarFileName);
			} catch (AmsException e) {
				e.printStackTrace();
				FileStorage.delete(jadFileName);
				return;
			}

			// Construct a command line
			String startupClass = (String) jadProperties.get(MAIN_CLASS);
			String commandLine = fConfiguartion.getCldcArguments(jarFileName, startupClass, fDebugArgs);

			// Launch the test
			ProgramLauncher.launchProgram(fConfiguartion.getProgramName(), commandLine, null, true);

			// Delete the file
			FileStorage.delete(jadFileName);
			FileStorage.delete(jarFileName);
		}
	}
}
