package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

import javax.microedition.rms.*;

public class InstallHistory {

	public static final String RMS_NAME = "ams.history"; //$NON-NLS-1$
	public static final int MAX_SIZE = 20;

	public static void addToHistory(String url){
		int recordId = -1;
		RecordStore recordStore = null;
		RecordEnumeration records = null;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			records = recordStore.enumerateRecords(null, null, false);

			// Check if pruning if required.
			if (records.numRecords() == MAX_SIZE) {
				recordId = records.nextRecordId();
				if (new String(recordStore.getRecord(recordId)).equals(url)) return;
			}

			while (records.hasNextElement()) {
				if (new String(records.nextRecord()).equals(url)) return;
			}
			recordStore.addRecord(url.getBytes(), 0, url.getBytes().length);

			//prune a record if required
			if (recordId != -1) recordStore.deleteRecord(recordId);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				recordStore.closeRecordStore();
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}

	public static String[] getHistory() {
		RecordStore recordStore = null;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			int length = recordStore.getNumRecords();
			if (length > 0) {
				RecordEnumeration records = recordStore.enumerateRecords(null, null, false);
				String[] urls = new String[length];

				/* Reverse the order to answer most recent url first. */
				while (records.hasNextElement()) {
					urls[--length] = new String(records.nextRecord());
				}

				return urls;
			}
		} catch (RecordStoreException r) {
			r.printStackTrace();
		} finally {
			if (recordStore != null) {
				try {
					recordStore.closeRecordStore();
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		}
		return null;
	}

	public static boolean isEmpty() {
		RecordStore recordStore = null;
		int length = 0;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, false);
			length = recordStore.getNumRecords();
		} catch (Exception e1) {
			/* do nothing */
		} finally {
			try {
				recordStore.closeRecordStore();
			} catch (Exception e1) {
				//TODO: print stack trace?
			}
		}
		return length == 0;
	}

	public static void clear() {
		try {
			RecordStore.deleteRecordStore(RMS_NAME);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
