package com.ibm.ive.midp.ams;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.*;
import com.ibm.oti.connection.file.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */
public class LaunchConfiguration {

	protected String fIveHome;
	protected String fBootclassPath;

	protected String fJXEPath;

	protected static final String ARG_BOOTPATH_PREFIX = "-Xbootclasspath/p:"; //$NON-NLS-1$
	protected static final String ARG_JXE_PREFIX = "-jxe:";	 //$NON-NLS-1$
	protected static final String ARG_JAR_PREFIX = "-jar:";	 //$NON-NLS-1$
	protected static final String ARG_CLASSPATH_PREFIX = "-classpath "; //$NON-NLS-1$
	protected static final String ARG_LIBRARIES = "-jcl:midp20"; //$NON-NLS-1$
	protected static final String ARG_STARTUP_CLASS = "javax.microedition.lcdui.AppManager"; //$NON-NLS-1$

	// This property is used to override the location of the executable that will be used
	// to launch MIDlets
	protected static final String PROPERTY_VM_EXECUTABLE = "com.ibm.midp.vm.executable"; //$NON-NLS-1$
	protected static final String SEPARATOR = System.getProperty("file.separator"); //$NON-NLS-1$
	protected static final String LINE_SEPARATOR = System.getProperty("line.separator"); //$NON-NLS-1$
	protected static final String PATH_SEPARATOR = System.getProperty("path.separator"); //$NON-NLS-1$

	/**
	 * Constructor for LaunchConfiguration.
	 */
	public LaunchConfiguration() {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
	}

	public String getIveHome() {
		if (fIveHome == null) fIveHome = System.getProperty("java.home");		 //$NON-NLS-1$

		return fIveHome;
	}

	protected String getJXEPath() {
		// Look for the special hook into the program args
		String jxepath = NativeGetJxeLocation();
		if (jxepath == null || jxepath.length() == 0) {
			if (fJXEPath == null) {
				fJXEPath = getIveHome() + SEPARATOR + "lib" + SEPARATOR + "jclMidp20" + SEPARATOR + "jclMidp20.jxe"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				try {
					new FileInputStream(fJXEPath);
					//TODO: close stream?
				} catch (ConnectionNotFoundException e) {
					// The jxe could not be found so we will default to using the classes.zip
					fJXEPath = ""; //$NON-NLS-1$
				}
			}
			jxepath = fJXEPath;
		}
		return jxepath;
	}

	public String getBootclassPath() {
		if (fBootclassPath == null) {
			fBootclassPath = getIveHome() + SEPARATOR + "lib" + SEPARATOR + "charconv.zip"; //$NON-NLS-1$ //$NON-NLS-2$
			try {
				InputStream stream = new FileInputStream(fBootclassPath);
				try {
					stream.close();
				} catch (IOException e) {
				}
			} catch (ConnectionNotFoundException e) {
				// The jxe could not be found so we will default to using the classes.zip
				fBootclassPath = ""; //$NON-NLS-1$
			}
			fBootclassPath = fBootclassPath + PATH_SEPARATOR + getJXEPath();
		}
		return fBootclassPath;
	}

	public String getProgramName() {
		// Check to see if the user has specified the location of the
		// vm executable
		String property = System.getProperty(PROPERTY_VM_EXECUTABLE);
		if (property != null) return property;

		// Since the program used to launch MIDlets was not overridden
		// the default location must be calculated from the ive home
		return getIveHome() + SEPARATOR + "bin" + SEPARATOR + "j9midp20.exe"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public StringBuffer getDefaultArgs(String vmOptions) {
		StringBuffer buffer = new StringBuffer();

		buffer.append(ARG_LIBRARIES);
		buffer.append(' ');

		Hashtable propertyList = (Hashtable) getSystemProperties();
		if (propertyList != null) {
			Enumeration keys = propertyList.keys();
			while (keys.hasMoreElements()) {
				String key = (String) keys.nextElement();
				String override = "-D" + key + '=' + (String) propertyList.get(key);
				buffer.append(quoteIfNeeded(override));
				buffer.append(' ');
			}
		}

		if (vmOptions != null && vmOptions.length() > 0) {
			buffer.append(vmOptions);
			buffer.append(' ');
		}
		return buffer;
	}

	void addJxeArg(StringBuffer buffer) {
		String jxepath = getJXEPath();

		if (jxepath != null && jxepath.length() != 0) {
			buffer.append(quoteIfNeeded(ARG_JXE_PREFIX + jxepath));
			buffer.append(' ');
		}
	}

	void addClasspath(StringBuffer buffer, String classpath) {
		buffer.append(ARG_CLASSPATH_PREFIX);
		buffer.append(quoteIfNeeded(classpath));
		buffer.append(' ');
	}

	void addBootclassPath(StringBuffer buffer) {
		String bootclasspath = getBootclassPath();
		if (bootclasspath != null && bootclasspath.length() != 0) {
			buffer.append(quoteIfNeeded(ARG_BOOTPATH_PREFIX + bootclasspath));
			buffer.append(' ');
		}
	}

	public String getProgramArguments(MidletEntry entry, String vmOptions) {
		StringBuffer buffer = getDefaultArgs(vmOptions);

		addClasspath(buffer, entry.getJarFile());
		addBootclassPath(buffer);
//		addJxeArg(buffer);
		buffer.append(' ');
		buffer.append(ARG_STARTUP_CLASS);
		buffer.append(' ');
		String jadFile = entry.getJadFile();
		if (jadFile != null) {
			buffer.append(quoteIfNeeded(jadFile));
			buffer.append(' ');
		}

		// fix for bug 106058
		buffer.append(quoteIfNeeded(ARG_JAR_PREFIX + entry.getJarFile()));

		return buffer.toString();
	}

	public String getCldcArguments(String jarFileName, String mainClass, String vmOptions) {
		StringBuffer buffer = getDefaultArgs(vmOptions);

		addClasspath(buffer, jarFileName);

		String bootclasspath = getBootclassPath();
		if (bootclasspath != null && bootclasspath.length() != 0) {
			buffer.append(quoteIfNeeded(ARG_BOOTPATH_PREFIX + bootclasspath));

			// Look for the special hook into the program args
			String jxepath = getJXEPath();
			if (jxepath != null && jxepath.length() != 0) {
				buffer.append(';');
				buffer.append(quoteIfNeeded(jxepath));
			}

			buffer.append(' ');
		}

		buffer.append(mainClass);
		return buffer.toString();
	}

	public String getMidpArguments(String classpath, String midletName, String vmOptions) {
		StringBuffer buffer = getDefaultArgs(vmOptions);
		addClasspath(buffer, classpath);
		addBootclassPath(buffer);
//		addJxeArg(buffer);
		buffer.append(' ');
		buffer.append(ARG_STARTUP_CLASS);
		buffer.append(' ');
		buffer.append(midletName);
		return buffer.toString();
	}

	public static String quoteIfNeeded(String value) {
		if (value.indexOf(' ') != -1 || value.indexOf(LINE_SEPARATOR) != -1) {
			StringBuffer sb = new StringBuffer("\"");
			char[] chars = value.toCharArray();
			for (int i = 0; i < chars.length; i++) {
				// Convert backward slash into forward slash
				if (chars[i] == '\\') {
					sb.append('/');
					continue;
				}
				// Escape quotes
				if (chars[i]  == '\"') sb.append('\\');
				sb.append(chars[i]);
			}
			sb.append("\"");
			return sb.toString();
		} else {
			return value;
		}
	}

	public static String getJxeLocation() {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
	    return (NativeGetJxeLocation());
	}

	private static native String NativeGetJxeLocation();
	private static native Object getSystemProperties();
}
