package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import java.io.*;
import java.util.*;

import com.ibm.ive.midp.*;
import com.ibm.ive.midp.util.*;
import javax.microedition.rms.*;
import com.ibm.oti.vm.VM;

public class MidletEntry {

	Hashtable fProperties = new Hashtable(20);

	static final String KEY_NAME = "MidletEntry.name"; //$NON-NLS-1$
	static final String KEY_VENDOR = "MidletEntry.vendor"; //$NON-NLS-1$
	static final String KEY_VERSION = "MidletEntry.version"; //$NON-NLS-1$
	static final String KEY_JAD_FILE = "MidletEntry.jad_file"; //$NON-NLS-1$
	static final String KEY_JAD_URL = "MidletEntry.jad_url"; //$NON-NLS-1$
	static final String KEY_JAR_FILE = "MidletEntry.jar_file"; //$NON-NLS-1$
	static final String KEY_JAR_SIZE = "MidletEntry.jar_size"; //$NON-NLS-1$
	static final String KEY_JAR_URL = "MidletEntry.jar_url"; //$NON-NLS-1$
	static final String KEY_ICON = "MidletEntry.icon"; //$NON-NLS-1$
	static final String KEY_DATA_SIZE = "MidletEntry.data_size"; //$NON-NLS-1$
	static final String KEY_PROFILE = "MicroEdition.Profile"; //$NON-NLS-1$
	static final String KEY_CONFIGURATION = "Microedition.configuration"; //$NON-NLS-1$
	static final String KEY_PERMISSIONS = "Midlet.permissions"; //$NON-NLS-1$
	static final String KEY_SECURITY_DOMAIN = "domain"; //$NON-NLS-1$
	static final String KEY_PRINCIPAL_NAME = "x509principal"; //$NON-NLS-1$
	static final String KEY_MIDLET_ID = "midlet.ID"; //$NON-NLS-1$
	static final String KEY_RECORD_ID = "record.ID"; //$NON-NLS-1$
	static final String KEY_SIGNED = "signed"; //$NON-NLS-1$

	// This field is only used when the fetchMidlet detects that the newly downloaded
	// midlet would be used to update a midlet already installed.  In every
	// other instance, this field will be null.
	public MidletEntry updatedMidlet;

	public MidletEntry() {
		setRecordID(MidletStorage.getNextRecordId());
		setMidletID(FileStorage.getNextAvailableFileId());
	}

	public MidletEntry(Hashtable properties) {
		//TODO - May require a copy.
		fProperties = properties;
	}

	public Hashtable getProperties() {
		String jadLocation = (String)fProperties.get(KEY_JAD_FILE);
		String jarFile = (String)fProperties.get(KEY_JAR_FILE);
		InputStream manifestStream = null;

		if (jarFile != null) {
			byte[] bytes = VM.manifestFromZip(jarFile);
			if (bytes != null) manifestStream = new ByteArrayInputStream(bytes);
		}
		return JadParser.parse(jadLocation, manifestStream);
	}

	public String getName() {
		return (String)fProperties.get(KEY_NAME);
	}

	public String getIcon() {
		return (String)fProperties.get(KEY_ICON);
	}

	public String getStorageName() {
		return getName() + '_' + getVendor();
	}

	public String getVendor() {
		return (String)fProperties.get(KEY_VENDOR);
	}

	public String getMIDPProfile() {
		return (String)fProperties.get(KEY_PROFILE);
	}

	public String getMIDPConfiguration() {
		return (String)fProperties.get(KEY_CONFIGURATION);
	}

	public String getMidletPermissions() {
		return (String)fProperties.get(KEY_PERMISSIONS);
	}

	public String getVersion() {
		return (String)fProperties.get(KEY_VERSION);
	}

	public void setName(String name) {
		fProperties.put(KEY_NAME, name);
	}

	public void setIcon(String name, Hashtable properties) {
		/*
		 * If there is no MIDlet-Icon, then we will treat the icon
		 * specified for MIDlet-1 as MIDletSuite's icon
		 */
		if (name == null) {
			String midletName = (String) properties.get("MIDlet-" + 1); //$NON-NLS-1$
			int index1 = midletName.indexOf(',') + 1;
			int index2 = midletName.indexOf(',', index1);
			name = midletName.substring(index1, index2);
		}
		if (name == null || (name = name.trim()).length() == 0) return;

		char firstChar = name.charAt(0);

		/*
		 * If firstChar is '/', it should be trimmed as VM.fileFromZip,
		 * which is used to retrieve the image, returns null.
		 */
		if (firstChar == '/' || firstChar == '\\') {
			fProperties.put(KEY_ICON, name.substring(1));
		} else {
			fProperties.put(KEY_ICON, name);
		}
	}

	public void setVendor(String vendor) {
		fProperties.put(KEY_VENDOR, vendor);
	}

	public void setVersion(String version) {
		fProperties.put(KEY_VERSION, version);
	}

	public void setMIDPProfile(String profile) {
		if (profile == null) return;

		fProperties.put(KEY_PROFILE, profile);
	}

	public void setMIDPConfiguration(String config) {
		if (config == null) return;

		fProperties.put(KEY_CONFIGURATION, config);
	}

	public void setMidletPermissions(String permissions) {
		if (permissions == null) return;

		fProperties.put(KEY_PERMISSIONS, permissions);
	}

	public void setJadFile(String jadFile) {
		fProperties.put(KEY_JAD_FILE, jadFile);
	}

	public String getJadFile() {
		return (String)fProperties.get(KEY_JAD_FILE);
	}

	public void setJarFile(String jarFile) {
		fProperties.put(KEY_JAR_FILE, jarFile);
	}

	public String getJarFile() {
		return (String)fProperties.get(KEY_JAR_FILE);
	}

	public void setJarSize(String jarSize) {
		fProperties.put(KEY_JAR_SIZE, jarSize);
	}

	public String getJarSize() {
		return (String)fProperties.get(KEY_JAR_SIZE);
	}

	public void setDataSize(String dataSize) {
		fProperties.put(KEY_DATA_SIZE, dataSize);
	}

	public String getDataSize() {
		return (String)fProperties.get(KEY_DATA_SIZE);
	}

	public void setJadURL(String jadURL) {
		fProperties.put(KEY_JAD_URL, jadURL);
	}

	public String getJadURL() {
		return (String)fProperties.get(KEY_JAD_URL);
	}

	public void setJarURL(String jarURL) {
		fProperties.put(KEY_JAR_URL, jarURL);
	}

	public String getJarURL() {
		return (String)fProperties.get(KEY_JAR_URL);
	}

	public void setMidletID(String ID){
		fProperties.put(KEY_MIDLET_ID,ID);
	}

	public String getMidletID(){
		return (String)fProperties.get(KEY_MIDLET_ID);
	}

	public void setRecordID(String ID){
		fProperties.put(KEY_RECORD_ID,ID);
	}

	public String getRecordID(){
		return (String)fProperties.get(KEY_RECORD_ID);
	}

	public void setKeyPrincipalName(String name) {
		fProperties.put(KEY_PRINCIPAL_NAME, name);
	}

	public String getKeyPrincipalName() {
		return (String)fProperties.get(KEY_PRINCIPAL_NAME);
	}

	public void setSecurityDomain(String domain) {
		fProperties.put(KEY_SECURITY_DOMAIN, domain);
	}

	/**
	 * Returns the security domain for this midlet.
	 *
	 * @return the security domain for this midlet.
	 */
	public String getSecurityDomain() {
		String domain = (String)fProperties.get(KEY_SECURITY_DOMAIN);
		// If the domain has not been set then it is
		// best to assume that it is untrusted
		if (domain == null) domain = "untrusted"; //$NON-NLS-1$
		return domain;
	}

	synchronized void writeToRecordStore(RecordStore recordStore){
		final String EOL = "\n"; //$NON-NLS-1$
		Enumeration e = fProperties.keys();
		StringBuffer buffer = new StringBuffer();

		while (e.hasMoreElements()) {
			String key = (String) e.nextElement();
			String value = (String) fProperties.get(key);

			// Make sure that the value does not contain an characters that are treated specially by
			// the manifest parser
			buffer.append(key);
			buffer.append(": "); //$NON-NLS-1$
			buffer.append(value);
			buffer.append(EOL);
		}

		String line = buffer.toString();
		try {
			if (Integer.parseInt(getRecordID()) == recordStore.getNextRecordID()) {
				recordStore.addRecord(line.getBytes(), 0, line.getBytes().length);
			} else {
				recordStore.setRecord(Integer.parseInt(getRecordID()), line.getBytes(), 0, line.getBytes().length);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public String[] getMIDletNames() {
		int midletNum = 1;

		Hashtable properties = getProperties();
		FastVector midletNames = new FastVector();
		String midletName = (String) properties.get("MIDlet-" + midletNum); //$NON-NLS-1$
		while (midletName != null) {
			midletName = midletName.substring(0, midletName.indexOf(','));
			midletNames.addElement(midletName);
			midletNum++;
			midletName = (String) properties.get("MIDlet-" + midletNum); //$NON-NLS-1$
		}

		String[] returnValue = new String[midletNames.size()];
		midletNames.copyInto(returnValue);
		return returnValue;
	}

	public void printToApplicationList(StringBuffer buffer) {
		/* The format of this information is described by the UEI spec. */
		buffer.append("  Name: "); //$NON-NLS-1$
		buffer.append(getName());
		buffer.append("\n  Vendor: "); //$NON-NLS-1$
		buffer.append(getVendor());
		buffer.append("\n  Version: "); //$NON-NLS-1$
		buffer.append(getVersion());
		buffer.append("\n  Storage name: "); //$NON-NLS-1$
		buffer.append(getStorageName());
		buffer.append("\n  Size: "); //$NON-NLS-1$
		buffer.append(getJarSize());
		buffer.append("\n  Installed From: "); //$NON-NLS-1$
		String source = getJadURL();
		if (source == null) source = getJarURL();
		buffer.append(source);
		buffer.append("\n  MIDlets: "); //$NON-NLS-1$

		String[] names = getMIDletNames();
		for (int i = 0; i < names.length; i++) {
			buffer.append("\n    ");
			buffer.append(names[i]);
		}
		buffer.append("\n");
	}

	public boolean isMidp10() {
		int version = 1;
		String midpVersion = getMIDPProfile();
		if (midpVersion != null) {
			int length = (midpVersion = midpVersion.trim()).length();
			int index = 0;
			/*
			 * MicroEdition-Profile can have more than one profile specified with
			 * space in between them. So, something like
			 * MicroEdition-Profile: MIDP-1.0 MIDP-2.0  is valid (one of the
			 * Security TCK case does so) and the MIDlet
			 * in this case should be treated as a MIDP 2.0 MIDlet
			 */
			while (index != -1) {
				int prevIndex = index;
				index = midpVersion.indexOf(' ', index + 1);
				if (midpVersion.substring(prevIndex, index == -1 ? length : index).trim().equals(MIDletManager.MIDP_20_STRING)) {
					version = 2;
					break;
				}
			}
		}
		return version == 1;
	}

}
