package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

import javax.microedition.rms.*;

public class PendingStatusReporter {

	static final String RMS_NAME = "ams.notification"; //$NON-NLS-1$
	// Keeping MAX_RETRIES 100 in line with the 3G America's requirement
	static final int MAX_RETRIES = 100;
	static Object gLock = new Object();
	static boolean gThreadRunning = false;
	static Thread gPendingStatusThread = null;

	public static void addNotification(int status, String url){
		synchronized (gLock) {
			RecordStore recordStore = null;
			try {
				recordStore = RecordStore.openRecordStore(RMS_NAME, true);
				// format for storing in RMS: <url> <status> <retry_count>
				// for example: "http://some.server.com/notifyInstall.cgi 900 1"
				byte[] buf = new StringBuffer(url).append(' ').append(status).append(' ').append(1).toString().getBytes();
				recordStore.addRecord(buf, 0, buf.length);
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					recordStore.closeRecordStore();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}
		}
	}

	public static void sendPendingStatusReports() {
		synchronized (gLock) {
			if (gThreadRunning || isEmpty()) return;
		}

		gPendingStatusThread = new Thread() {
			public void run() {
				while (true) {
					String[][] records;
					synchronized (gLock) {
						records = getRecords();
						if (records == null) {
							gThreadRunning = false;
							return; // No records: no need to retry. Exit thread.
						}
						gThreadRunning = true;
					}
					for (int i = 0; i < records.length; i++) { // go through all pending ones and try them
						synchronized (gLock) {
							try {
								MessageDispatch.reportStatus(getStatus(records[i][1]), getURL(records[i][1]));
								deleteRecord(Integer.parseInt(records[i][0]));
							} catch (Exception e) {
								handleRetries(Integer.parseInt(records[i][0]), records[i][1]);
								e.printStackTrace();
							}
						}
					}
					try {
						// sleep after going through the list
						Thread.sleep(30*1000); // 30 seconds
					} catch (InterruptedException e) {
					}
				}
			}
		};

		gPendingStatusThread.start();
	}

	static String getURL(String recordString) {
		return recordString.substring(0, recordString.indexOf(' '));
	}

	static int getStatus(String recordString) {
		int firstSpaceIndex = recordString.indexOf(' ');
		return Integer.parseInt(recordString.substring(firstSpaceIndex + 1, recordString.indexOf(' ', firstSpaceIndex+1)));
	}

	static int getRetries(String recordString) {
		return Integer.parseInt(recordString.substring(recordString.indexOf(' ') + 1));
	}

	static void setRetries(int recordId, String recordString, int retries) {
		RecordStore recordStore = null;
		byte[] newRecord = (recordString.substring(0, recordString.indexOf(' ') + 1) + retries).getBytes();
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			recordStore.setRecord(recordId, newRecord, 0, newRecord.length);
		} catch (RecordStoreException r) {
			r.printStackTrace();
		} finally {
			if (recordStore != null) {
				try {
					recordStore.closeRecordStore();
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		}
	}

	static String[][] getRecords() {
		RecordStore recordStore = null;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			int length = recordStore.getNumRecords();
			if (length > 0) {
				RecordEnumeration records = recordStore.enumerateRecords(null, null, false);
				String[][] urls = new String[length][2];

				while (records.hasNextElement()) {
					int rec = records.nextRecordId();
					urls[--length][0] = String.valueOf(rec);
					urls[length][1] = new String(recordStore.getRecord(rec));
				}
				return urls;
			}
		} catch (RecordStoreException r) {
			r.printStackTrace();
		} finally {
			if (recordStore != null) {
				try {
					recordStore.closeRecordStore();
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		}
		return null;
	}

	static void deleteRecord(int recordId) {
		RecordStore recordStore = null;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			recordStore.deleteRecord(recordId);
		} catch (RecordStoreException r) {
			r.printStackTrace();
		} finally {
			if (recordStore != null) {
				try {
					recordStore.closeRecordStore();
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		}
	}

	static void handleRetries(int recordId, String recordString) {
		int retries = getRetries(recordString);
		if (retries < MAX_RETRIES) {
			setRetries(recordId, recordString, retries + 1);
		} else {
			deleteRecord(recordId);
		}
	}

	static boolean isEmpty() {
		RecordStore recordStore = null;
		int length = 0;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, false);
			length = recordStore.getNumRecords();
		} catch (Exception e1) {
			/* do nothing */
		} finally {
			try {
				recordStore.closeRecordStore();
			} catch (Exception e1) {
				/* do nothing */
			}
		}
		return length == 0;
	}
}
