package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

public class Version {
	private int fNumTokens;
	private int fTokens[];

	public Version(String version) {
		fNumTokens = getNumTokens();
		initialize(version);
	}

	public String asExpandedString() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < fNumTokens; i++) {
			sb.append(padLeft(Integer.toString(fTokens[i]), '0', 4)); //$NON-NLS-1$
			if (i + 1 < fNumTokens) sb.append("."); //$NON-NLS-1$
		}
		return sb.toString();
	}

	public int[] asIntArray() {
		return fTokens;
	}

	public boolean earlierThan(Version targetVersion) {
		return this.asExpandedString().compareTo(targetVersion.asExpandedString()) < 0;
	}

	public boolean equals(Version targetVersion) {
		int[] tempArray = targetVersion.asIntArray();
		for (int i = 0; i < fNumTokens; i++) {
			if (fTokens[i] != tempArray[i]) return false;
		}
		return true;
	}

	public boolean equals(String v) {
		return equals(new Version(v));
	}

	public int getNumTokens() {
		return 3;
	}

	void initialize(String version) {
		fTokens = new int[fNumTokens];
		for (int i = 0; i < fNumTokens; i++) {
			fTokens[i] = 0;
		}
		if (version == null || (version.trim().length() == 0)) return;
		fTokens = getTokens(version, fNumTokens);
	}

	public boolean laterThan(Version targetVersion) {
		return this.asExpandedString().compareTo(targetVersion.asExpandedString()) > 0;
	}

	String padLeft(String aString, char padCharacter, int length) {
		StringBuffer sb = new StringBuffer(aString);
		int count = length - sb.length();
		for (int i = 0; i < count; i++) {
			sb.insert(0, padCharacter);
		}
		return sb.toString();
	}

	int[] getTokens(String s, int maxTokens) {
		int i = 0;
		int parts[] = new int[maxTokens];
		int count = 0;
		char ch;
		String t;
		int len = s.length();

		t = ""; //$NON-NLS-1$
		for (i = 0; i < len; i++) {
			ch = s.charAt(i);
			if (ch == '.') {
				if (count < maxTokens) parts[count] = Integer.parseInt(t);
				count++;
				t = ""; //$NON-NLS-1$
			} else {
				t += ch;
			}
		}
		if (t.length() > 0) parts[maxTokens - 1] = Integer.parseInt(t);
		return parts;
	}
}
