package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2006  All Rights Reserved
 */

import javax.microedition.lcdui.*;
import com.ibm.ive.midp.*;

public class AboutPage implements CommandListener {

	Displayable fPreviousDisplayable;
	Display fDisplay;
	Form fAboutForm;

	Form buildForm() {
		if (fAboutForm == null) {
			fAboutForm = new Form(MidpMsg.getString("AboutPage.buildForm.title")); //$NON-NLS-1$
			String emulatorString = UEIHandler.EMULATOR_VERSION;
			if (UEIHandler.gBuildVersion != null) emulatorString = emulatorString + " " + MidpMsg.getString("AboutPage.buildForm.build", UEIHandler.gBuildVersion); //$NON-NLS-1$

			StringItem strItem = new StringItem(null, emulatorString);
			strItem.setFont(Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_MEDIUM));
			fAboutForm.append(strItem);

			String fullVersion = System.getProperty("java.fullversion");//$NON-NLS-1$
			if (fullVersion != null) fAboutForm.append(fullVersion);

			fAboutForm.append(MidpMsg.getString("AboutPage.buildForm.licensedMaterial"));//$NON-NLS-1$
			fAboutForm.append(MidpMsg.getString("AboutPage.buildForm.copyright"));//$NON-NLS-1$
			fAboutForm.append(MidpMsg.getString("AboutPage.buildForm.trademark"));//$NON-NLS-1$
			fAboutForm.append(new StringItem(MidpMsg.getString("AboutPage.buildForm.version"), "MIDP 2.0")); //$NON-NLS-1$//$NON-NLS-2$

			fAboutForm.addCommand(CommandFactory.getCommand(CommandFactory.BACK_COMMAND));
			fAboutForm.setCommandListener(this);
		}
		return fAboutForm;
	}

	public void show(Display display) {
		fDisplay = display;
		fPreviousDisplayable = fDisplay.getCurrent();
		fDisplay.setCurrent(buildForm());
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gBackCommand) {
			fDisplay.setCurrent(fPreviousDisplayable);
		}
	}
}
